/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.config;

import com.graphaware.common.ping.StatsCollector;
import com.graphaware.runtime.config.RuntimeConfiguration;
import com.graphaware.runtime.schedule.TimingStrategy;
import com.graphaware.runtime.write.WritingConfig;

public abstract class BaseRuntimeConfiguration
implements RuntimeConfiguration {
    private final TimingStrategy timingStrategy;
    private final WritingConfig writingConfig;
    private final StatsCollector statsCollector;

    protected BaseRuntimeConfiguration(TimingStrategy timingStrategy, WritingConfig writingConfig, StatsCollector statsCollector) {
        this.timingStrategy = timingStrategy;
        this.writingConfig = writingConfig;
        this.statsCollector = statsCollector;
    }

    public TimingStrategy getTimingStrategy() {
        return this.timingStrategy;
    }

    public WritingConfig getWritingConfig() {
        return this.writingConfig;
    }

    public StatsCollector getStatsCollector() {
        return this.statsCollector;
    }

    public String createPrefix(String id) {
        return "_GA_" + id + "_";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseRuntimeConfiguration that = (BaseRuntimeConfiguration)o;
        if (!this.writingConfig.equals(that.writingConfig)) {
            return false;
        }
        if (!this.timingStrategy.equals(that.timingStrategy)) {
            return false;
        }
        return this.statsCollector.equals(that.statsCollector);
    }

    public int hashCode() {
        int result = this.timingStrategy.hashCode();
        result = 31 * result + this.writingConfig.hashCode();
        result = 31 * result + this.statsCollector.hashCode();
        return result;
    }
}

