/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.config;

import com.graphaware.common.ping.GoogleAnalyticsStatsCollector;
import com.graphaware.common.ping.StatsCollector;
import com.graphaware.runtime.config.BaseRuntimeConfiguration;
import com.graphaware.runtime.schedule.AdaptiveTimingStrategy;
import com.graphaware.runtime.schedule.TimingStrategy;
import com.graphaware.runtime.write.FluentWritingConfig;
import com.graphaware.runtime.write.WritingConfig;
import org.neo4j.graphdb.GraphDatabaseService;

public final class FluentRuntimeConfiguration
extends BaseRuntimeConfiguration {
    public static FluentRuntimeConfiguration defaultConfiguration(GraphDatabaseService database) {
        return new FluentRuntimeConfiguration(AdaptiveTimingStrategy.defaultConfiguration(), FluentWritingConfig.defaultConfiguration(), (StatsCollector)new GoogleAnalyticsStatsCollector(database));
    }

    private FluentRuntimeConfiguration(TimingStrategy timingStrategy, WritingConfig writingConfig, StatsCollector statsCollector) {
        super(timingStrategy, writingConfig, statsCollector);
    }

    public FluentRuntimeConfiguration withTimingStrategy(TimingStrategy timingStrategy) {
        return new FluentRuntimeConfiguration(timingStrategy, this.getWritingConfig(), this.getStatsCollector());
    }

    public FluentRuntimeConfiguration withWritingConfig(WritingConfig writingConfig) {
        return new FluentRuntimeConfiguration(this.getTimingStrategy(), writingConfig, this.getStatsCollector());
    }

    public FluentRuntimeConfiguration withStatsCollector(StatsCollector statsCollector) {
        return new FluentRuntimeConfiguration(this.getTimingStrategy(), this.getWritingConfig(), statsCollector);
    }
}

