/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.config.function;

import com.graphaware.common.policy.inclusion.InclusionPolicy;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

public abstract class StringToInclusionPolicy<T extends InclusionPolicy>
implements Function<String, T> {
    private static final Pattern CLASS_NAME_REGEX = Pattern.compile("([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*");
    private static final Set<String> ALL_BUSINESS_NODES_POLICY = new HashSet<String>(Arrays.asList("true", "all"));
    private static final Set<String> EXCLUDE_ALL_NODES_POLICY = new HashSet<String>(Arrays.asList("false", "none"));

    @Override
    public T apply(String s) {
        if (ALL_BUSINESS_NODES_POLICY.contains(s)) {
            return this.all();
        }
        if (EXCLUDE_ALL_NODES_POLICY.contains(s)) {
            return this.none();
        }
        if (CLASS_NAME_REGEX.matcher(s).matches()) {
            try {
                Class<?> clazz = Class.forName(s);
                try {
                    Method method = clazz.getMethod("getInstance", new Class[0]);
                    return (T)this.compositePolicy((InclusionPolicy)method.invoke(clazz, new Object[0]));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return (T)this.compositePolicy((InclusionPolicy)clazz.newInstance());
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.compositePolicy(this.spelPolicy(s));
    }

    protected abstract T compositePolicy(T var1);

    protected abstract T spelPolicy(String var1);

    protected abstract T all();

    protected abstract T none();
}

