/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.config.util;

import com.graphaware.common.log.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.neo4j.logging.Log;

public final class ConfigUtils {
    private static final Log LOG = LoggerFactory.getLogger(ConfigUtils.class);

    private ConfigUtils() {
    }

    public static <T> T instantiate(Map<String, String> config, String configKey, String tryingToInstantiateWhat, String whatHappensWhenInstantiationFails) {
        if (config.get(configKey) != null) {
            String className = config.get(configKey);
            LOG.info("Trying to instantiate class " + className);
            try {
                Class<?> cls = Class.forName(className);
                try {
                    LOG.info("Attempting to instantiate as a singleton...");
                    Method factoryMethod = cls.getDeclaredMethod("getInstance", new Class[0]);
                    Object result = factoryMethod.invoke(null, null);
                    LOG.info("Success.");
                    return (T)result;
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    LOG.debug("Not a singleton.");
                    LOG.info("Attempting to instantiate using public no-arg constructor...");
                    Object result = cls.newInstance();
                    LOG.info("Success.");
                    return (T)result;
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error(tryingToInstantiateWhat + " " + className + " wasn't found on the classpath. " + whatHappensWhenInstantiationFails, (Throwable)e);
                throw new RuntimeException(tryingToInstantiateWhat + " " + className + " wasn't found on the classpath. " + whatHappensWhenInstantiationFails, e);
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException e) {
                LOG.error("Could not instantiate " + tryingToInstantiateWhat + " " + className + ". " + whatHappensWhenInstantiationFails, (Throwable)e);
                throw new RuntimeException("Could not instantiate " + tryingToInstantiateWhat + " " + className + ". " + whatHappensWhenInstantiationFails, e);
            }
        }
        LOG.error(whatHappensWhenInstantiationFails + " No " + tryingToInstantiateWhat + " specified!");
        throw new RuntimeException(whatHappensWhenInstantiationFails + " No " + tryingToInstantiateWhat + " specified!");
    }
}

