/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.config.util;

import com.graphaware.common.policy.role.InstanceRole;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKey;

public class InstanceRoleUtils {
    private final GraphDatabaseService database;

    public InstanceRoleUtils(GraphDatabaseService database) {
        this.database = database;
    }

    protected <T> T resolveDependency(Class<T> type) {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)this.database).getDependencyResolver();
        return (T)dependencyResolver.resolveDependency(type);
    }

    public OperationalMode getOperationalMode() {
        UsageData usageData = this.resolveDependency(UsageData.class);
        OperationalMode opMode = (OperationalMode)usageData.get(new UsageDataKey("neo4j.opMode", null));
        return opMode;
    }

    public InstanceRole getInstanceRole() {
        InstanceRole res;
        OperationalMode operationalMode = this.getOperationalMode();
        switch (operationalMode) {
            case ha: {
                res = this.getHARole();
                break;
            }
            case core: {
                res = this.getCoreRole();
                break;
            }
            case read_replica: {
                res = InstanceRole.READ_REPLICA;
                break;
            }
            default: {
                res = InstanceRole.SINGLE;
            }
        }
        return res;
    }

    private InstanceRole getCoreRole() {
        try {
            Role role = this.resolveDependency(RaftMachine.class).currentRole();
            if (role == Role.LEADER) {
                return InstanceRole.LEADER;
            }
            if (role == Role.FOLLOWER) {
                return InstanceRole.FOLLOWER;
            }
            if (role == Role.CANDIDATE) {
                return InstanceRole.CANDIDATE;
            }
            return InstanceRole.SINGLE;
        }
        catch (NoClassDefFoundError e) {
            return InstanceRole.SINGLE;
        }
    }

    private InstanceRole getHARole() {
        try {
            String role = this.resolveDependency(ClusterMembers.class).getCurrentMemberRole();
            if ("master".equalsIgnoreCase(role)) {
                return InstanceRole.MASTER;
            }
            return InstanceRole.SLAVE;
        }
        catch (NoClassDefFoundError e) {
            return InstanceRole.SINGLE;
        }
    }
}

