/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.listener;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.policy.role.InstanceRole;
import com.graphaware.runtime.listener.TopologyChangeEvent;
import com.graphaware.runtime.listener.TopologyListener;
import com.graphaware.runtime.listener.TopologyListenerAdapter;
import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.logging.Log;

public class HighAvailabilityClusterListener
implements ClusterListener,
TopologyListener {
    protected final Log LOG = LoggerFactory.getLogger(HighAvailabilityClusterListener.class);
    private final DependencyResolver dependencyResolver;
    private final TopologyListenerAdapter adapter;

    public HighAvailabilityClusterListener(DependencyResolver dependencyResolver, TopologyListenerAdapter adapter) {
        this.dependencyResolver = dependencyResolver;
        this.adapter = adapter;
    }

    @Override
    public void register() {
        ((ClusterClient)this.dependencyResolver.resolveDependency(ClusterClient.class)).addClusterListener((ClusterListener)this);
    }

    @Override
    public void unregister() {
        ((ClusterClient)this.dependencyResolver.resolveDependency(ClusterClient.class)).removeClusterListener((ClusterListener)this);
    }

    private ClusterMembers getHAClusterMembers() {
        return (ClusterMembers)this.dependencyResolver.resolveDependency(ClusterMembers.class);
    }

    private InstanceRole haInstanceRoleFromString(String haInstanceRole) {
        return haInstanceRole.equals("master") ? InstanceRole.MASTER : InstanceRole.SLAVE;
    }

    private TopologyChangeEvent topologyChangeEventFromHighAvailability(InstanceId instanceId, TopologyChangeEvent.EventType eventType) {
        ClusterMember thisMember = this.getHAClusterMembers().getCurrentMember();
        return new TopologyListener.TopologyChangeEventImpl(instanceId.toString(), thisMember.getInstanceId().toString(), this.haInstanceRoleFromString(thisMember.getHARole()), eventType);
    }

    private TopologyChangeEvent topologyChangeEventFromHighAvailabilityElection(InstanceId instanceId) {
        ClusterMember thisMember = this.getHAClusterMembers().getCurrentMember();
        InstanceRole role = InstanceRole.SLAVE;
        if (instanceId.equals((Object)thisMember.getInstanceId())) {
            role = InstanceRole.MASTER;
        }
        return new TopologyListener.TopologyChangeEventImpl(instanceId.toString(), thisMember.getInstanceId().toString(), role, TopologyChangeEvent.EventType.ELECTION);
    }

    public void enteredCluster(ClusterConfiguration clusterConfiguration) {
    }

    public void leftCluster() {
    }

    public void joinedCluster(InstanceId instanceId, URI uri) {
        this.adapter.fireEvent(this.topologyChangeEventFromHighAvailability(instanceId, TopologyChangeEvent.EventType.CLUSTER_JOIN));
    }

    public void leftCluster(InstanceId instanceId, URI uri) {
        this.adapter.fireEvent(this.topologyChangeEventFromHighAvailability(instanceId, TopologyChangeEvent.EventType.CLUSTER_LEAVE));
    }

    public void elected(String s, InstanceId instanceId, URI uri) {
        this.adapter.fireEvent(this.topologyChangeEventFromHighAvailabilityElection(instanceId));
    }

    public void unelected(String s, InstanceId instanceId, URI uri) {
    }
}

