/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.listener;

import com.graphaware.common.policy.role.InstanceRole;
import com.graphaware.runtime.listener.TopologyChangeEvent;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface TopologyListener {
    public void register();

    public void unregister();

    public static class TopologyChangeEventImpl
    implements TopologyChangeEvent {
        private final String instanceId;
        private final String ownInstanceId;
        private final TopologyChangeEvent.EventType eventType;
        private final InstanceRole ownInstanceRole;

        public TopologyChangeEventImpl(String instanceId, String ownInstanceId, InstanceRole ownInstanceRole, TopologyChangeEvent.EventType eventType) {
            this.instanceId = instanceId;
            this.ownInstanceId = ownInstanceId;
            this.ownInstanceRole = ownInstanceRole;
            this.eventType = eventType;
        }

        @Override
        public String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getOwnInstanceId() {
            return this.ownInstanceId;
        }

        @Override
        public InstanceRole getOwnInstanceRole() {
            return this.ownInstanceRole;
        }

        @Override
        public TopologyChangeEvent.EventType getEventType() {
            return this.eventType;
        }

        public String toString() {
            return Stream.of("[instanceId=", this.getInstanceId(), ",ownInstanceId=", this.getOwnInstanceId(), ",ownInstanceRole=", this.getOwnInstanceRole().toString(), ",eventType=", this.getEventType().toString() + "]").collect(Collectors.joining());
        }
    }
}

