/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.listener;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.runtime.config.util.InstanceRoleUtils;
import com.graphaware.runtime.listener.CausalClusterListener;
import com.graphaware.runtime.listener.HighAvailabilityClusterListener;
import com.graphaware.runtime.listener.TopologyChangeEvent;
import com.graphaware.runtime.listener.TopologyChangeEventListener;
import com.graphaware.runtime.listener.TopologyListener;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public final class TopologyListenerAdapter {
    protected final Log LOG = LoggerFactory.getLogger(TopologyListenerAdapter.class);
    List<TopologyChangeEventListener> topologyChangeEventListeners = new ArrayList<TopologyChangeEventListener>();
    private DependencyResolver dependencyResolver;
    private OperationalMode operationalMode;
    private TopologyListener topologyListener;

    public TopologyListenerAdapter(GraphDatabaseAPI api) {
        this.operationalMode = new InstanceRoleUtils((GraphDatabaseService)api).getOperationalMode();
        this.dependencyResolver = api.getDependencyResolver();
        if (this.operationalMode.equals((Object)OperationalMode.ha)) {
            this.topologyListener = new HighAvailabilityClusterListener(this.dependencyResolver, this);
        }
        if (this.operationalMode.equals((Object)OperationalMode.core)) {
            this.topologyListener = new CausalClusterListener(this.dependencyResolver, this);
        }
        this.topologyListener.register();
    }

    public void registerListener(TopologyChangeEventListener topologyChangeEventListener) {
        this.topologyChangeEventListeners.add(topologyChangeEventListener);
    }

    public void removeListener(TopologyChangeEventListener topologyChangeEventListener) {
        this.topologyChangeEventListeners.remove(topologyChangeEventListener);
    }

    public void unregister() {
        this.topologyChangeEventListeners.clear();
        this.topologyListener.unregister();
    }

    protected final void fireEvent(TopologyChangeEvent topologyChangeEvent) {
        this.topologyChangeEventListeners.forEach(listener -> listener.onTopologyChange(topologyChangeEvent));
    }
}

