/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.manager;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.ping.StatsCollector;
import com.graphaware.runtime.manager.ModuleManager;
import com.graphaware.runtime.metadata.CorruptMetadataException;
import com.graphaware.runtime.metadata.ModuleMetadata;
import com.graphaware.runtime.metadata.ModuleMetadataRepository;
import com.graphaware.runtime.module.RuntimeModule;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.logging.Log;

public abstract class BaseModuleManager<M extends ModuleMetadata, T extends RuntimeModule>
implements ModuleManager<T> {
    private static final Log LOG = LoggerFactory.getLogger(BaseModuleManager.class);
    protected final Map<String, T> modules = new LinkedHashMap<String, T>();
    protected final ModuleMetadataRepository metadataRepository;
    private final StatsCollector statsCollector;

    protected BaseModuleManager(ModuleMetadataRepository metadataRepository, StatsCollector statsCollector) {
        this.metadataRepository = metadataRepository;
        this.statsCollector = statsCollector;
    }

    @Override
    public final void registerModule(T module) {
        this.modules.put(module.getId(), module);
    }

    @Override
    public <M extends RuntimeModule> M getModule(String moduleId, Class<M> clazz) {
        if (!this.modules.containsKey(moduleId)) {
            return null;
        }
        RuntimeModule module = (RuntimeModule)this.modules.get(moduleId);
        if (!clazz.isAssignableFrom(module.getClass())) {
            LOG.warn("Module " + moduleId + " is not a " + clazz.getName());
            return null;
        }
        return (M)module;
    }

    @Override
    public <M extends RuntimeModule> M getModule(Class<M> clazz) {
        RuntimeModule result = null;
        for (RuntimeModule module : this.modules.values()) {
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            if (result != null) {
                throw new IllegalStateException("More than one module of type " + clazz + " has been registered");
            }
            result = module;
        }
        return (M)result;
    }

    @Override
    public void checkNotAlreadyRegistered(RuntimeModule module) {
        if (this.modules.values().contains(module)) {
            LOG.error("Module " + module.getId() + " cannot be registered more than once!");
            throw new IllegalStateException("Module " + module.getId() + " cannot be registered more than once!");
        }
        if (this.modules.containsKey(module.getId())) {
            LOG.error("Module " + module.getId() + " cannot be registered more than once!");
            throw new IllegalStateException("Module " + module.getId() + " cannot be registered more than once!");
        }
    }

    @Override
    public final Set<String> loadMetadata() {
        HashSet<String> moduleIds = new HashSet<String>();
        for (RuntimeModule module : this.modules.values()) {
            moduleIds.add(module.getId());
            LOG.info("Loading metadata for module " + module.getId());
            this.loadMetadata(module);
        }
        return moduleIds;
    }

    private void loadMetadata(T module) {
        M moduleMetadata = null;
        try {
            moduleMetadata = this.metadataRepository.getModuleMetadata((RuntimeModule)module);
            if (moduleMetadata == null) {
                LOG.info("Module " + module.getId() + " seems to have been registered for the first time.");
                this.handleNoMetadata(module);
            } else {
                LOG.info("Module " + module.getId() + " seems to have been registered before, metadata loaded successfully.");
            }
        }
        catch (CorruptMetadataException e) {
            LOG.info("Module " + module.getId() + " seems to have corrupted metadata.");
            this.handleCorruptMetadata(module);
        }
        if (moduleMetadata == null) {
            LOG.info("Creating fresh metadata for module " + module.getId() + ".");
            moduleMetadata = this.createFreshMetadata(module);
        }
        moduleMetadata = this.acknowledgeMetadata(module, moduleMetadata);
        this.persistMetadata(module, moduleMetadata);
    }

    protected void handleCorruptMetadata(T module) {
    }

    protected void handleNoMetadata(T module) {
    }

    protected abstract M createFreshMetadata(T var1);

    protected abstract M acknowledgeMetadata(T var1, M var2);

    private void persistMetadata(T module, M metadata) {
        this.metadataRepository.persistModuleMetadata((RuntimeModule)module, metadata);
    }

    @Override
    public void cleanupMetadata(Set<String> usedModules) {
        Set<String> unusedModules = this.metadataRepository.getAllModuleIds();
        unusedModules.removeAll(usedModules);
        for (String moduleId : unusedModules) {
            LOG.info("Removing unused module " + moduleId + ".");
            this.metadataRepository.removeModuleMetadata(moduleId);
        }
    }

    @Override
    public void startModules() {
        for (RuntimeModule module : this.modules.values()) {
            this.statsCollector.moduleStart(module.getClass().getCanonicalName());
        }
    }

    @Override
    public void shutdownModules() {
        for (RuntimeModule module : this.modules.values()) {
            LOG.info("Shutting down module " + module.getId());
            module.shutdown();
        }
    }
}

