/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.manager;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.ping.StatsCollector;
import com.graphaware.runtime.config.util.InstanceRoleUtils;
import com.graphaware.runtime.manager.BaseModuleManager;
import com.graphaware.runtime.manager.TxDrivenModuleManager;
import com.graphaware.runtime.metadata.DefaultTxDrivenModuleMetadata;
import com.graphaware.runtime.metadata.ModuleMetadataRepository;
import com.graphaware.runtime.metadata.TxDrivenModuleMetadata;
import com.graphaware.runtime.module.DeliberateTransactionRollbackException;
import com.graphaware.runtime.module.NeedsInitializationException;
import com.graphaware.runtime.module.TxDrivenModule;
import com.graphaware.tx.event.improved.api.FilteredTransactionData;
import com.graphaware.tx.event.improved.api.ImprovedTransactionData;
import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.logging.Log;

public abstract class BaseTxDrivenModuleManager<T extends TxDrivenModule>
extends BaseModuleManager<TxDrivenModuleMetadata, T>
implements TxDrivenModuleManager<T> {
    private static final Log LOG = LoggerFactory.getLogger(BaseTxDrivenModuleManager.class);
    private final InstanceRoleUtils instanceRoleUtils;

    protected BaseTxDrivenModuleManager(ModuleMetadataRepository metadataRepository, StatsCollector statsCollector, InstanceRoleUtils instanceRoleUtils) {
        super(metadataRepository, statsCollector);
        this.instanceRoleUtils = instanceRoleUtils;
    }

    @Override
    protected void handleCorruptMetadata(T module) {
        LOG.info("Module " + module.getId() + " seems to have corrupted metadata, will try to re-initialize...");
        this.reinitializeIfAllowed(module, null);
    }

    @Override
    protected void handleNoMetadata(T module) {
        LOG.info("Module " + module.getId() + " seems to have been registered for the first time, will try to initialize...");
        this.initializeIfAllowed(module);
    }

    @Override
    protected TxDrivenModuleMetadata createFreshMetadata(T module) {
        return new DefaultTxDrivenModuleMetadata(module.getConfiguration());
    }

    @Override
    protected TxDrivenModuleMetadata acknowledgeMetadata(T module, TxDrivenModuleMetadata metadata) {
        if (metadata.needsInitialization()) {
            LOG.info("Module " + module.getId() + " has been marked for re-initialization on " + new Date(metadata.problemTimestamp()).toString() + ". Will try to re-initialize...");
            this.reinitializeIfAllowed(module, metadata);
            return this.createFreshMetadata(module);
        }
        if (!metadata.getConfig().equals(module.getConfiguration())) {
            LOG.info("Module " + module.getId() + " seems to have changed configuration since last run, will try to re-initialize...");
            this.reinitializeIfAllowed(module, metadata);
            return this.createFreshMetadata(module);
        }
        LOG.info("Module " + module.getId() + " has not changed configuration since last run, already initialized.");
        return metadata;
    }

    @Override
    public void startModules() {
        super.startModules();
        LOG.info("Starting transaction-driven modules...");
        for (TxDrivenModule module : this.modules.values()) {
            this.start(module);
        }
        LOG.info("Transaction-driven modules started.");
    }

    protected abstract void start(T var1);

    private void initializeIfAllowed(T module) {
        if (this.allowedToInitialize(module, "initialize")) {
            this.initialize(module);
        }
    }

    private void reinitializeIfAllowed(T module, TxDrivenModuleMetadata metadata) {
        if (this.allowedToInitialize(module, "re-initialize")) {
            this.reinitialize(module, metadata);
        }
    }

    private boolean allowedToInitialize(T module, String logMessage) {
        long now;
        if (this.instanceRoleUtils.getInstanceRole().isReadOnly()) {
            LOG.info("Instance not writable. Will NOT " + logMessage + ".");
            return false;
        }
        long initUntil = module.getConfiguration().initializeUntil();
        if (initUntil > (now = System.currentTimeMillis())) {
            LOG.info("InitializeUntil set to " + initUntil + " and it is " + now + ". Will " + logMessage + ".");
            return true;
        }
        LOG.info("InitializeUntil set to " + initUntil + " and it is " + now + ". Will NOT " + logMessage + ".");
        return false;
    }

    protected abstract void initialize(T var1);

    protected abstract void reinitialize(T var1, TxDrivenModuleMetadata var2);

    @Override
    public Map<String, Object> beforeCommit(TransactionDataContainer transactionData) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (TxDrivenModule module : this.modules.values()) {
            FilteredTransactionData filteredTransactionData = new FilteredTransactionData(transactionData, module.getConfiguration().getInclusionPolicies());
            if (!filteredTransactionData.mutationsOccurred()) continue;
            Object state = null;
            try {
                state = module.beforeCommit((ImprovedTransactionData)filteredTransactionData);
            }
            catch (NeedsInitializationException e) {
                LOG.warn("Module " + module.getId() + " seems to have a problem and will be re-initialized next time the database is started. ");
                TxDrivenModuleMetadata moduleMetadata = (TxDrivenModuleMetadata)this.metadataRepository.getModuleMetadata(module);
                this.metadataRepository.persistModuleMetadata(module, moduleMetadata.markedNeedingInitialization());
            }
            catch (DeliberateTransactionRollbackException e) {
                LOG.debug("Module " + module.getId() + " threw an exception indicating that the transaction should be rolled back.", (Throwable)e);
                return this.handleException(result, module, state, e);
            }
            catch (RuntimeException e) {
                LOG.warn("Module " + module.getId() + " threw an exception", (Throwable)e);
                return this.handleException(result, module, state, e);
            }
            result.put(module.getId(), state);
        }
        return result;
    }

    private Map<String, Object> handleException(Map<String, Object> result, T module, Object state, RuntimeException e) {
        result.put(module.getId(), state);
        this.afterRollback(result);
        throw e;
    }

    @Override
    public void afterCommit(Map<String, Object> states) {
        for (TxDrivenModule module : this.modules.values()) {
            if (!states.containsKey(module.getId())) {
                return;
            }
            module.afterCommit(states.get(module.getId()));
        }
    }

    @Override
    public void afterRollback(Map<String, Object> states) {
        for (TxDrivenModule module : this.modules.values()) {
            if (!states.containsKey(module.getId())) {
                return;
            }
            module.afterRollback(states.get(module.getId()));
        }
    }
}

