/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.manager;

import com.graphaware.common.ping.StatsCollector;
import com.graphaware.runtime.manager.BaseModuleManager;
import com.graphaware.runtime.manager.TimerDrivenModuleManager;
import com.graphaware.runtime.metadata.DefaultTimerDrivenModuleMetadata;
import com.graphaware.runtime.metadata.ModuleMetadataRepository;
import com.graphaware.runtime.metadata.TimerDrivenModuleContext;
import com.graphaware.runtime.metadata.TimerDrivenModuleMetadata;
import com.graphaware.runtime.module.TimerDrivenModule;
import com.graphaware.runtime.schedule.RotatingTaskScheduler;
import com.graphaware.runtime.schedule.TaskScheduler;
import com.graphaware.runtime.schedule.TimingStrategy;
import org.neo4j.graphdb.GraphDatabaseService;

public class ProductionTimerDrivenModuleManager
extends BaseModuleManager<TimerDrivenModuleMetadata, TimerDrivenModule>
implements TimerDrivenModuleManager {
    private final GraphDatabaseService database;
    private final TaskScheduler taskScheduler;

    public ProductionTimerDrivenModuleManager(GraphDatabaseService database, ModuleMetadataRepository metadataRepository, TimingStrategy timingStrategy, StatsCollector statsCollector) {
        super(metadataRepository, statsCollector);
        this.database = database;
        this.taskScheduler = new RotatingTaskScheduler(database, metadataRepository, timingStrategy);
    }

    @Override
    protected TimerDrivenModuleMetadata createFreshMetadata(TimerDrivenModule module) {
        return new DefaultTimerDrivenModuleMetadata((TimerDrivenModuleContext)module.createInitialContext(this.database));
    }

    @Override
    protected TimerDrivenModuleMetadata acknowledgeMetadata(TimerDrivenModule module, TimerDrivenModuleMetadata metadata) {
        this.taskScheduler.registerModuleAndContext(module, metadata.lastContext());
        return metadata;
    }

    @Override
    public void startModules() {
        super.startModules();
        this.taskScheduler.start();
    }

    @Override
    public void shutdownModules() {
        super.shutdownModules();
        this.taskScheduler.stop();
    }
}

