/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.monitor;

import com.graphaware.common.util.BoundedConcurrentStack;
import com.graphaware.common.util.Pair;
import java.util.Iterator;

public class RunningWindowAverage {
    private final BoundedConcurrentStack<Pair<Long, Long>> timesAndValues;
    private final int maxTime;

    public RunningWindowAverage(int maxSamples, int maxTime) {
        this.timesAndValues = new BoundedConcurrentStack(maxSamples);
        this.maxTime = maxTime;
    }

    public void sample(long time, long value) {
        this.timesAndValues.push((Object)new Pair((Object)time, (Object)value));
    }

    public long getAverage() {
        Pair next;
        if (this.timesAndValues.isEmpty()) {
            return -1L;
        }
        Iterator iterator = this.timesAndValues.iterator();
        Pair latest = (Pair)iterator.next();
        long latestTime = (Long)latest.first();
        long latestValue = (Long)latest.second();
        if (!iterator.hasNext()) {
            return -1L;
        }
        long pastTime = 0L;
        long pastValue = 0L;
        while (iterator.hasNext() && latestTime - (Long)(next = (Pair)iterator.next()).first() <= (long)this.maxTime) {
            pastTime = (Long)next.first();
            pastValue = (Long)next.second();
        }
        int period = Long.valueOf(latestTime - pastTime).intValue();
        if (period < 1) {
            return -1L;
        }
        return (latestValue - pastValue) * 1000L / (long)period;
    }
}

