/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.schedule;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.runtime.schedule.DelayAdjuster;
import org.neo4j.logging.Log;

public class ConstantDeltaDelayAdjuster
implements DelayAdjuster {
    private static final Log LOG = LoggerFactory.getLogger(ConstantDeltaDelayAdjuster.class);
    private final long delta;
    private final long defaultDelay;
    private final long minDelay;
    private final long maxDelay;
    private final long busyThreshold;

    public ConstantDeltaDelayAdjuster(long delta, long defaultDelay, long minDelay, long maxDelay, long busyThreshold) {
        this.delta = delta;
        this.defaultDelay = defaultDelay;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.busyThreshold = busyThreshold;
    }

    @Override
    public long determineNextDelay(long currentDelay, long lastTaskDuration, long load) {
        if (currentDelay < 0L) {
            return this.defaultDelay;
        }
        if (load > this.busyThreshold) {
            long result = Math.min(currentDelay + this.delta, this.maxDelay);
            this.log(result, load);
            return result;
        }
        long result = Math.max(currentDelay - this.delta, this.minDelay);
        this.log(result, load);
        return result;
    }

    private void log(long result, long rate) {
        LOG.debug("Next delay updated to %s ms based on average load of %s tx/s", new Object[]{result, rate});
    }
}

