/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.schedule;

import com.graphaware.runtime.schedule.TimingStrategy;
import org.neo4j.graphdb.GraphDatabaseService;

public class FixedDelayTimingStrategy
implements TimingStrategy {
    private final long initialDelay;
    private final long delay;

    public static FixedDelayTimingStrategy getInstance() {
        return new FixedDelayTimingStrategy(1000L, 200L);
    }

    private FixedDelayTimingStrategy(long initialDelay, long delay) {
        this.initialDelay = initialDelay;
        this.delay = delay;
    }

    public FixedDelayTimingStrategy withInitialDelay(long initialDelay) {
        return new FixedDelayTimingStrategy(initialDelay, this.delay);
    }

    public FixedDelayTimingStrategy withDelay(long delay) {
        return new FixedDelayTimingStrategy(this.initialDelay, delay);
    }

    @Override
    public void initialize(GraphDatabaseService database) {
    }

    @Override
    public long nextDelay(long lastTaskDuration) {
        if (lastTaskDuration == -2L) {
            return this.initialDelay;
        }
        return this.delay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedDelayTimingStrategy strategy = (FixedDelayTimingStrategy)o;
        if (this.delay != strategy.delay) {
            return false;
        }
        return this.initialDelay == strategy.initialDelay;
    }

    public int hashCode() {
        int result = (int)(this.initialDelay ^ this.initialDelay >>> 32);
        result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
        return result;
    }
}

