/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.walk;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.policy.inclusion.NodeInclusionPolicy;
import com.graphaware.runtime.policy.all.IncludeAllBusinessNodes;
import com.graphaware.runtime.walk.NodeSelector;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public class ContinuousNodeSelector
implements NodeSelector {
    private static final Log LOG = LoggerFactory.getLogger(ContinuousNodeSelector.class);
    private final NodeInclusionPolicy inclusionPolicy;
    private final AtomicLong lastId;

    public ContinuousNodeSelector() {
        this(IncludeAllBusinessNodes.getInstance());
    }

    public ContinuousNodeSelector(long lastNodeId) {
        this(IncludeAllBusinessNodes.getInstance(), lastNodeId);
    }

    public ContinuousNodeSelector(NodeInclusionPolicy inclusionPolicy) {
        this(inclusionPolicy, -1L);
    }

    public ContinuousNodeSelector(NodeInclusionPolicy inclusionPolicy, long lastNodeId) {
        this.inclusionPolicy = inclusionPolicy;
        this.lastId = new AtomicLong(lastNodeId);
    }

    @Override
    public Node selectNode(GraphDatabaseService database) {
        int attempt = 0;
        while (true) {
            try {
                Node node;
                do {
                    if (++attempt == 1000) {
                        LOG.warn("Did not find a suitable node in 1000 attempts. Are you sure the node inclusion policy is set correctly for ContinuousNodeSelector?");
                    }
                    if (attempt != 1000000) continue;
                    LOG.warn("Did not find a suitable node in 1M attempts. Aborting...");
                    return null;
                } while (!this.inclusionPolicy.include((Object)(node = database.getNodeById(this.nextId(database)))));
                return node;
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            break;
        }
    }

    private long nextId(GraphDatabaseService database) {
        long highestId = ((RecordStorageEngine)((GraphDatabaseAPI)database).getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getNodeStore().getHighestPossibleIdInUse();
        long nextId = this.lastId.incrementAndGet();
        if (nextId > highestId) {
            this.lastId.set(-1L);
            nextId = this.lastId.incrementAndGet();
        }
        return nextId;
    }
}

