/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.runtime.GraphAwareRuntime;
import com.graphaware.runtime.RuntimeRegistry;
import com.graphaware.runtime.config.RuntimeConfiguration;
import com.graphaware.runtime.manager.TimerDrivenModuleManager;
import com.graphaware.runtime.manager.TxDrivenModuleManager;
import com.graphaware.runtime.module.RuntimeModule;
import com.graphaware.runtime.module.TimerDrivenModule;
import com.graphaware.runtime.module.TxDrivenModule;
import com.graphaware.tx.event.improved.api.ImprovedTransactionData;
import com.graphaware.tx.event.improved.api.LazyTransactionData;
import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import com.graphaware.writer.neo4j.Neo4jWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.logging.Log;

public class CommunityRuntime
implements TransactionEventHandler<Map<String, Object>>,
GraphAwareRuntime,
KernelEventHandler {
    private static final Log LOG = LoggerFactory.getLogger(CommunityRuntime.class);
    private static final ThreadLocal<Boolean> STARTING = ThreadLocal.withInitial(() -> false);
    private volatile State state = State.NONE;
    private final RuntimeConfiguration configuration;
    private final GraphDatabaseService database;
    private final TxDrivenModuleManager<TxDrivenModule> txDrivenModuleManager;
    private final TimerDrivenModuleManager timerDrivenModuleManager;
    private final Neo4jWriter writer;

    protected CommunityRuntime(RuntimeConfiguration configuration, GraphDatabaseService database, TxDrivenModuleManager<TxDrivenModule> txDrivenModuleManager, TimerDrivenModuleManager timerDrivenModuleManager, Neo4jWriter writer) {
        if (!State.NONE.equals((Object)this.state)) {
            throw new IllegalStateException("Only one instance of the GraphAware Runtime should ever be instantiated and started.");
        }
        if (RuntimeRegistry.getRuntime((GraphDatabaseService)database) != null) {
            throw new IllegalStateException("It is not possible to create multiple runtimes for a single database!");
        }
        this.state = State.REGISTERED;
        this.configuration = configuration;
        this.database = database;
        this.txDrivenModuleManager = txDrivenModuleManager;
        this.timerDrivenModuleManager = timerDrivenModuleManager;
        this.writer = writer;
        database.registerTransactionEventHandler((TransactionEventHandler)this);
        database.registerKernelEventHandler((KernelEventHandler)this);
        RuntimeRegistry.registerRuntime((GraphDatabaseService)database, (GraphAwareRuntime)this);
    }

    public synchronized void registerModule(RuntimeModule module) {
        if (!State.REGISTERED.equals((Object)this.state)) {
            LOG.error("Modules must be registered before GraphAware Runtime is started!");
            throw new IllegalStateException("Modules must be registered before GraphAware Runtime is started!");
        }
        LOG.info("Registering module " + module.getId() + " with GraphAware Runtime.");
        this.txDrivenModuleManager.checkNotAlreadyRegistered(module);
        this.timerDrivenModuleManager.checkNotAlreadyRegistered(module);
        if (module instanceof TxDrivenModule) {
            this.txDrivenModuleManager.registerModule((TxDrivenModule)module);
        }
        if (module instanceof TimerDrivenModule) {
            this.timerDrivenModuleManager.registerModule((TimerDrivenModule)module);
        }
    }

    public final synchronized void start() {
        if (State.STARTED.equals((Object)this.state)) {
            LOG.debug("GraphAware already started");
            return;
        }
        if (State.STARTING.equals((Object)this.state)) {
            throw new IllegalStateException("Attempt to start GraphAware from multiple different threads. This is a bug");
        }
        if (!State.REGISTERED.equals((Object)this.state)) {
            throw new IllegalStateException("Illegal Runtime state " + (Object)((Object)this.state) + "! This is a bug");
        }
        STARTING.set(true);
        LOG.info("Starting GraphAware...");
        this.state = State.STARTING;
        this.beforeStart();
        this.startStatsCollector();
        this.handleModuleMetadata();
        this.startModules();
        this.startWriter();
        this.state = State.STARTED;
        LOG.info("GraphAware started.");
        STARTING.set(false);
    }

    private void startStatsCollector() {
        this.configuration.getStatsCollector().runtimeStart();
    }

    protected void handleModuleMetadata() {
        LOG.info("Loading module metadata...");
        HashSet<String> moduleIds = new HashSet<String>();
        moduleIds.addAll(this.txDrivenModuleManager.loadMetadata());
        moduleIds.addAll(this.timerDrivenModuleManager.loadMetadata());
        this.txDrivenModuleManager.cleanupMetadata(moduleIds);
        this.timerDrivenModuleManager.cleanupMetadata(moduleIds);
        LOG.info("Module metadata loaded.");
    }

    private void startModules() {
        this.txDrivenModuleManager.startModules();
        this.timerDrivenModuleManager.startModules();
    }

    private void startWriter() {
        this.getDatabaseWriter().start();
    }

    protected void beforeStart() {
    }

    public final void waitUntilStarted() {
        if (!this.isStarted(null)) {
            throw new IllegalStateException("It appears that the thread starting the runtime called waitUntilStarted() before it's finished its job. This is a bug");
        }
    }

    public Map<String, Object> beforeCommit(TransactionData data) {
        LazyTransactionData transactionData = new LazyTransactionData(data);
        if (!this.isStarted((ImprovedTransactionData)transactionData)) {
            return null;
        }
        return this.txDrivenModuleManager.beforeCommit((TransactionDataContainer)transactionData);
    }

    public final void afterCommit(TransactionData data, Map<String, Object> states) {
        if (states == null) {
            return;
        }
        this.txDrivenModuleManager.afterCommit(states);
    }

    public final void afterRollback(TransactionData data, Map<String, Object> states) {
        if (states == null) {
            return;
        }
        this.txDrivenModuleManager.afterRollback(states);
    }

    private boolean isStarted(ImprovedTransactionData transactionData) {
        if (State.NONE.equals((Object)this.state)) {
            throw new IllegalStateException("Runtime has not been registered! This is a bug.");
        }
        if (State.SHUTDOWN.equals((Object)this.state)) {
            throw new IllegalStateException("Runtime is being / has been shut down.");
        }
        int attempts = 0;
        while (!State.STARTED.equals((Object)this.state)) {
            if (transactionData != null && !transactionData.mutationsOccurred()) {
                return false;
            }
            if (State.STARTING.equals((Object)this.state) && STARTING.get().booleanValue()) {
                return false;
            }
            try {
                if (++attempts > 100 && State.REGISTERED.equals((Object)this.state)) {
                    throw new IllegalStateException("Runtime has not been started!");
                }
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    public void beforeShutdown() {
        LOG.info("Shutting down GraphAware Runtime... ");
        this.state = State.SHUTDOWN;
        this.doStop();
        RuntimeRegistry.removeRuntime((GraphDatabaseService)this.database);
        LOG.info("GraphAware Runtime shut down.");
    }

    protected void doStop() {
        this.txDrivenModuleManager.shutdownModules();
        this.timerDrivenModuleManager.shutdownModules();
        this.getDatabaseWriter().stop();
    }

    public <M extends RuntimeModule> M getModule(String moduleId, Class<M> clazz) throws NotFoundException {
        M module = this.txDrivenModuleManager.getModule(moduleId, clazz);
        if (module != null) {
            return module;
        }
        module = this.timerDrivenModuleManager.getModule(moduleId, clazz);
        if (module != null) {
            return module;
        }
        throw new NotFoundException("No module of type " + clazz.getName() + " with ID " + moduleId + " has been registered");
    }

    public <M extends RuntimeModule> M getModule(Class<M> clazz) throws NotFoundException {
        M txResult = this.txDrivenModuleManager.getModule(clazz);
        M timerResult = this.timerDrivenModuleManager.getModule(clazz);
        if (txResult != null && timerResult != null && timerResult != txResult) {
            throw new IllegalStateException("More than one module of type " + clazz + " has been registered");
        }
        if (txResult == null && timerResult == null) {
            throw new NotFoundException("No module of type " + clazz.getName() + " has been registered");
        }
        return txResult == null ? timerResult : txResult;
    }

    public final void kernelPanic(ErrorState error) {
    }

    public final Object getResource() {
        return null;
    }

    public final KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
        return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
    }

    public RuntimeConfiguration getConfiguration() {
        return this.configuration;
    }

    public Neo4jWriter getDatabaseWriter() {
        return this.writer;
    }

    private static enum State {
        NONE,
        REGISTERED,
        STARTING,
        STARTED,
        SHUTDOWN;

    }
}

