/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime;

import com.graphaware.runtime.CommunityRuntime;
import com.graphaware.runtime.GraphAwareRuntime;
import com.graphaware.runtime.config.FluentRuntimeConfiguration;
import com.graphaware.runtime.config.RuntimeConfiguration;
import com.graphaware.runtime.manager.CommunityTimerDrivenModuleManager;
import com.graphaware.runtime.manager.CommunityTxDrivenModuleManager;
import com.graphaware.runtime.metadata.GraphPropertiesMetadataRepository;
import com.graphaware.runtime.module.TxDrivenModule;
import org.neo4j.graphdb.GraphDatabaseService;

public final class GraphAwareRuntimeFactory {
    public static GraphAwareRuntime createRuntime(GraphDatabaseService database) {
        return GraphAwareRuntimeFactory.createRuntime(database, FluentRuntimeConfiguration.defaultConfiguration(database));
    }

    public static GraphAwareRuntime createRuntime(GraphDatabaseService database, RuntimeConfiguration configuration) {
        GraphPropertiesMetadataRepository timerRepo = new GraphPropertiesMetadataRepository(database, configuration, "TIMER_MODULE");
        GraphPropertiesMetadataRepository txRepo = new GraphPropertiesMetadataRepository(database, configuration, "TX_MODULE");
        CommunityTimerDrivenModuleManager timerDrivenModuleManager = new CommunityTimerDrivenModuleManager(database, timerRepo, configuration.getTimingStrategy(), configuration.getStatsCollector());
        CommunityTxDrivenModuleManager<TxDrivenModule> txDrivenModuleManager = new CommunityTxDrivenModuleManager<TxDrivenModule>(database, txRepo, configuration.getStatsCollector());
        return new CommunityRuntime(configuration, database, txDrivenModuleManager, timerDrivenModuleManager, configuration.getWritingConfig().produceWriter(database));
    }

    private GraphAwareRuntimeFactory() {
    }
}

