/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.config;

import com.graphaware.common.ping.GoogleAnalyticsStatsCollector;
import com.graphaware.common.ping.NullStatsCollector;
import com.graphaware.common.ping.StatsCollector;
import com.graphaware.runtime.config.BaseRuntimeConfiguration;
import com.graphaware.runtime.config.function.StringToDatabaseWriterType;
import com.graphaware.runtime.config.function.StringToTimingStrategy;
import com.graphaware.runtime.schedule.AdaptiveTimingStrategy;
import com.graphaware.runtime.schedule.FixedDelayTimingStrategy;
import com.graphaware.runtime.schedule.TimingStrategy;
import com.graphaware.runtime.write.DatabaseWriterType;
import com.graphaware.runtime.write.FluentWritingConfig;
import com.graphaware.runtime.write.WritingConfig;
import java.util.function.Function;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;

public final class Neo4jConfigBasedRuntimeConfiguration
extends BaseRuntimeConfiguration {
    private static final Setting<DatabaseWriterType> DATABASE_WRITER_TYPE_SETTING = Settings.setting((String)"com.graphaware.runtime.db.writer", (Function)StringToDatabaseWriterType.getInstance(), (String)null);
    private static final Setting<Integer> WRITER_QUEUE_SIZE = Settings.setting((String)"com.graphaware.runtime.db.writer.queueSize", (Function)Settings.INTEGER, (String)null);
    private static final Setting<Integer> WRITER_BATCH_SIZE = Settings.setting((String)"com.graphaware.runtime.db.writer.batchSize", (Function)Settings.INTEGER, (String)null);
    private static final Setting<TimingStrategy> TIMING_STRATEGY_SETTING = Settings.setting((String)"com.graphaware.runtime.timing.strategy", (Function)StringToTimingStrategy.getInstance(), (String)null);
    private static final Setting<Long> DELAY_SETTING = Settings.setting((String)"com.graphaware.runtime.timing.delay", (Function)Settings.LONG, (String)null);
    private static final Setting<Long> INITIAL_DELAY_SETTING = Settings.setting((String)"com.graphaware.runtime.timing.initialDelay", (Function)Settings.LONG, (String)null);
    private static final Setting<Long> MAX_DELAY_SETTING = Settings.setting((String)"com.graphaware.runtime.timing.maxDelay", (Function)Settings.LONG, (String)null);
    private static final Setting<Long> MIN_DELAY_SETTING = Settings.setting((String)"com.graphaware.runtime.timing.minDelay", (Function)Settings.LONG, (String)null);
    private static final Setting<Integer> BUSY_THRESHOLD_SETTING = Settings.setting((String)"com.graphaware.runtime.timing.busyThreshold", (Function)Settings.INTEGER, (String)null);
    private static final Setting<Integer> MAX_SAMPLES_SETTING = Settings.setting((String)"com.graphaware.runtime.timing.maxSamples", (Function)Settings.INTEGER, (String)null);
    private static final Setting<Integer> MAX_TIME_SETTING = Settings.setting((String)"com.graphaware.runtime.timing.maxTime", (Function)Settings.INTEGER, (String)null);
    private static final Setting<Boolean> STATS_DISABLE_SETTING_LEGACY = Settings.setting((String)"com.graphaware.runtime.stats.disable", (Function)Settings.BOOLEAN, (String)"false");
    private static final Setting<Boolean> STATS_DISABLE_SETTING = Settings.setting((String)"com.graphaware.runtime.stats.disabled", (Function)Settings.BOOLEAN, (String)"false");

    public Neo4jConfigBasedRuntimeConfiguration(GraphDatabaseService database, Config config) {
        super(config, Neo4jConfigBasedRuntimeConfiguration.createTimingStrategy(config), Neo4jConfigBasedRuntimeConfiguration.createWritingConfig(config), Neo4jConfigBasedRuntimeConfiguration.createStatsCollector(database, config));
    }

    private static TimingStrategy createTimingStrategy(Config config) {
        TimingStrategy timingStrategy = (TimingStrategy)config.get(TIMING_STRATEGY_SETTING);
        if (timingStrategy == null) {
            timingStrategy = AdaptiveTimingStrategy.defaultConfiguration();
        }
        if (timingStrategy instanceof FixedDelayTimingStrategy) {
            FixedDelayTimingStrategy strategy = (FixedDelayTimingStrategy)timingStrategy;
            if (config.get(INITIAL_DELAY_SETTING) != null) {
                strategy = strategy.withInitialDelay((Long)config.get(INITIAL_DELAY_SETTING));
            }
            if (config.get(DELAY_SETTING) != null) {
                strategy = strategy.withDelay((Long)config.get(DELAY_SETTING));
            }
            return strategy;
        }
        if (timingStrategy instanceof AdaptiveTimingStrategy) {
            AdaptiveTimingStrategy strategy = (AdaptiveTimingStrategy)timingStrategy;
            if (config.get(DELAY_SETTING) != null) {
                strategy = strategy.withDefaultDelayMillis((Long)config.get(DELAY_SETTING));
            }
            if (config.get(MAX_DELAY_SETTING) != null) {
                strategy = strategy.withMaximumDelayMillis((Long)config.get(MAX_DELAY_SETTING));
            }
            if (config.get(MIN_DELAY_SETTING) != null) {
                strategy = strategy.withMinimumDelayMillis((Long)config.get(MIN_DELAY_SETTING));
            }
            if (config.get(BUSY_THRESHOLD_SETTING) != null) {
                strategy = strategy.withBusyThreshold((Integer)config.get(BUSY_THRESHOLD_SETTING));
            }
            if (config.get(MAX_SAMPLES_SETTING) != null) {
                strategy = strategy.withMaxSamples((Integer)config.get(MAX_SAMPLES_SETTING));
            }
            if (config.get(MAX_TIME_SETTING) != null) {
                strategy = strategy.withMaxTime((Integer)config.get(MAX_TIME_SETTING));
            }
            return strategy;
        }
        throw new IllegalStateException("Unknown timing strategy!");
    }

    private static WritingConfig createWritingConfig(Config config) {
        DatabaseWriterType databaseWriterType = (DatabaseWriterType)config.get(DATABASE_WRITER_TYPE_SETTING);
        FluentWritingConfig result = FluentWritingConfig.defaultConfiguration();
        if (databaseWriterType != null) {
            result = result.withWriterType(databaseWriterType);
        }
        if (config.get(WRITER_QUEUE_SIZE) != null) {
            result = result.withQueueSize((Integer)config.get(WRITER_QUEUE_SIZE));
        }
        if (config.get(WRITER_BATCH_SIZE) != null) {
            result = result.withBatchSize((Integer)config.get(WRITER_BATCH_SIZE));
        }
        return result;
    }

    private static StatsCollector createStatsCollector(GraphDatabaseService database, Config config) {
        if (((Boolean)config.get(STATS_DISABLE_SETTING_LEGACY)).booleanValue()) {
            return NullStatsCollector.getInstance();
        }
        if (((Boolean)config.get(STATS_DISABLE_SETTING)).booleanValue()) {
            return NullStatsCollector.getInstance();
        }
        return new GoogleAnalyticsStatsCollector(database, config);
    }
}

