/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.metadata;

import com.graphaware.common.kv.GraphKeyValueStore;
import com.graphaware.common.kv.KeyValueStore;
import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.serialize.Serializer;
import com.graphaware.runtime.config.RuntimeConfiguration;
import com.graphaware.runtime.metadata.CorruptMetadataException;
import com.graphaware.runtime.metadata.ModuleMetadata;
import com.graphaware.runtime.metadata.ModuleMetadataRepository;
import com.graphaware.runtime.module.RuntimeModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class GraphPropertiesMetadataRepository
implements ModuleMetadataRepository {
    private static final Log LOG = LoggerFactory.getLogger(GraphPropertiesMetadataRepository.class);
    private final GraphDatabaseService database;
    private final KeyValueStore keyValueStore;
    private final String propertyPrefix;

    public GraphPropertiesMetadataRepository(GraphDatabaseService database, RuntimeConfiguration configuration, String propertyPrefix) {
        this.database = database;
        this.propertyPrefix = configuration.createPrefix(propertyPrefix);
        this.keyValueStore = new GraphKeyValueStore(database);
    }

    @Override
    public <M extends ModuleMetadata> M getModuleMetadata(RuntimeModule module) {
        return this.getModuleMetadata(module.getId());
    }

    @Override
    public <M extends ModuleMetadata> M getModuleMetadata(String moduleId) {
        String key = this.moduleKey(moduleId);
        Map<String, Object> internalProperties = this.getInternalProperties();
        try {
            byte[] serializedMetadata = (byte[])internalProperties.get(key);
            if (serializedMetadata == null) {
                return null;
            }
            return (M)((ModuleMetadata)Serializer.fromByteArray((byte[])serializedMetadata));
        }
        catch (Exception e) {
            this.removeModuleMetadata(moduleId);
            LOG.error("Could not deserialize metadata for module ID " + moduleId);
            throw new CorruptMetadataException(e);
        }
    }

    @Override
    public <M extends ModuleMetadata> void persistModuleMetadata(RuntimeModule module, M metadata) {
        this.persistModuleMetadata(module.getId(), metadata);
    }

    @Override
    public <M extends ModuleMetadata> void persistModuleMetadata(String moduleId, M metadata) {
        try (Transaction tx = this.database.beginTx();){
            this.keyValueStore.set(this.moduleKey(moduleId), (Object)Serializer.toByteArray(metadata));
            tx.success();
        }
    }

    @Override
    public Set<String> getAllModuleIds() {
        return this.getInternalProperties().keySet().stream().map(key -> key.replace(this.propertyPrefix, "")).collect(Collectors.toSet());
    }

    @Override
    public void removeModuleMetadata(String moduleId) {
        try (Transaction tx = this.database.beginTx();){
            this.keyValueStore.remove(this.moduleKey(moduleId));
            tx.success();
        }
    }

    private Map<String, Object> getInternalProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (Transaction tx = this.database.beginTx();){
            for (String key : this.keyValueStore.getKeys()) {
                if (!key.startsWith(this.propertyPrefix)) continue;
                result.put(key, this.keyValueStore.get(key));
            }
            tx.success();
        }
        return result;
    }

    protected final String moduleKey(String moduleId) {
        return this.propertyPrefix + moduleId;
    }
}

