/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.module;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.policy.inclusion.NodeInclusionPolicy;
import com.graphaware.common.policy.inclusion.NodePropertyInclusionPolicy;
import com.graphaware.common.policy.inclusion.RelationshipInclusionPolicy;
import com.graphaware.common.policy.inclusion.RelationshipPropertyInclusionPolicy;
import com.graphaware.runtime.config.BaseTxDrivenModuleConfiguration;
import com.graphaware.runtime.config.function.StringToNodeInclusionPolicy;
import com.graphaware.runtime.config.function.StringToNodePropertyInclusionPolicy;
import com.graphaware.runtime.config.function.StringToRelationshipInclusionPolicy;
import com.graphaware.runtime.config.function.StringToRelationshipPropertyInclusionPolicy;
import com.graphaware.runtime.module.RuntimeModule;
import com.graphaware.runtime.module.RuntimeModuleBootstrapper;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;

public abstract class BaseRuntimeModuleBootstrapper<C extends BaseTxDrivenModuleConfiguration<C>>
implements RuntimeModuleBootstrapper {
    private static final Log LOG = LoggerFactory.getLogger(BaseRuntimeModuleBootstrapper.class);
    protected static final String INITIALIZE_UNTIL = "initializeUntil";
    protected static final String NODE = "node";
    protected static final String NODE_PROPERTY = "node.property";
    protected static final String RELATIONSHIP = "relationship";
    protected static final String RELATIONSHIP_PROPERTY = "relationship.property";

    protected abstract C defaultConfiguration();

    @Override
    public RuntimeModule bootstrapModule(String moduleId, Map<String, String> config, GraphDatabaseService database) {
        C configuration = this.defaultConfiguration();
        configuration = this.configureInitialization(moduleId, config, configuration);
        configuration = this.configureInclusionPolicies(config, configuration);
        return this.doBootstrapModule(moduleId, config, database, configuration);
    }

    protected C configureInitialization(String moduleId, Map<String, String> config, C configuration) {
        if (this.configExists(config, INITIALIZE_UNTIL)) {
            configuration = ((BaseTxDrivenModuleConfiguration)configuration).withInitializeUntil(Long.valueOf(config.get(INITIALIZE_UNTIL)));
            this.logInitUntil(moduleId, configuration);
        }
        return configuration;
    }

    protected C configureInclusionPolicies(Map<String, String> config, C configuration) {
        NodeInclusionPolicy policy;
        if (this.configExists(config, NODE)) {
            policy = (NodeInclusionPolicy)StringToNodeInclusionPolicy.getInstance().apply(config.get(NODE));
            LOG.info("Node Inclusion Policy set to %s", new Object[]{policy});
            configuration = ((BaseTxDrivenModuleConfiguration)configuration).with(policy);
        }
        if (this.configExists(config, NODE_PROPERTY)) {
            policy = (NodePropertyInclusionPolicy)StringToNodePropertyInclusionPolicy.getInstance().apply(config.get(NODE_PROPERTY));
            LOG.info("Node Property Inclusion Policy set to %s", new Object[]{policy});
            configuration = ((BaseTxDrivenModuleConfiguration)configuration).with((NodePropertyInclusionPolicy)policy);
        }
        if (this.configExists(config, RELATIONSHIP)) {
            policy = (RelationshipInclusionPolicy)StringToRelationshipInclusionPolicy.getInstance().apply(config.get(RELATIONSHIP));
            LOG.info("Relationship Inclusion Policy set to %s", new Object[]{policy});
            configuration = ((BaseTxDrivenModuleConfiguration)configuration).with((RelationshipInclusionPolicy)policy);
        }
        if (this.configExists(config, RELATIONSHIP_PROPERTY)) {
            policy = (RelationshipPropertyInclusionPolicy)StringToRelationshipPropertyInclusionPolicy.getInstance().apply(config.get(RELATIONSHIP_PROPERTY));
            LOG.info("Relationship Property Inclusion Policy set to %s", new Object[]{policy});
            configuration = ((BaseTxDrivenModuleConfiguration)configuration).with((RelationshipPropertyInclusionPolicy)policy);
        }
        return configuration;
    }

    protected abstract RuntimeModule doBootstrapModule(String var1, Map<String, String> var2, GraphDatabaseService var3, C var4);

    protected final boolean configExists(Map<String, String> config, String key) {
        return config.get(key) != null && config.get(key).length() > 0;
    }

    private void logInitUntil(String moduleId, C configuration) {
        LOG.info(moduleId + " (re-)initialize until set to %s", new Object[]{this.initUntilAsString(configuration)});
        if (((BaseTxDrivenModuleConfiguration)configuration).initializeUntil() != Long.MAX_VALUE && ((BaseTxDrivenModuleConfiguration)configuration).initializeUntil() != 0L) {
            long now = System.currentTimeMillis();
            LOG.info("That's " + Math.abs(now - ((BaseTxDrivenModuleConfiguration)configuration).initializeUntil()) + " ms in the " + (now > ((BaseTxDrivenModuleConfiguration)configuration).initializeUntil() ? "past" : "future"));
        }
    }

    private String initUntilAsString(C configuration) {
        if (((BaseTxDrivenModuleConfiguration)configuration).initializeUntil() == 0L) {
            return "NEVER";
        }
        if (((BaseTxDrivenModuleConfiguration)configuration).initializeUntil() == Long.MAX_VALUE) {
            return "ALWAYS";
        }
        return String.valueOf(((BaseTxDrivenModuleConfiguration)configuration).initializeUntil());
    }
}

