/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.module.thirdparty;

import com.graphaware.common.representation.DetachedNode;
import com.graphaware.common.representation.DetachedRelationship;
import com.graphaware.runtime.module.BaseTxDrivenModule;
import com.graphaware.runtime.module.DeliberateTransactionRollbackException;
import com.graphaware.tx.event.improved.api.ImprovedTransactionData;
import com.graphaware.writer.thirdparty.NodeCreated;
import com.graphaware.writer.thirdparty.NodeDeleted;
import com.graphaware.writer.thirdparty.NodeUpdated;
import com.graphaware.writer.thirdparty.RelationshipCreated;
import com.graphaware.writer.thirdparty.RelationshipDeleted;
import com.graphaware.writer.thirdparty.RelationshipUpdated;
import com.graphaware.writer.thirdparty.WriteOperation;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public abstract class ThirdPartyIntegrationModule<ID>
extends BaseTxDrivenModule<Collection<WriteOperation<?>>> {
    protected ThirdPartyIntegrationModule(String moduleId) {
        super(moduleId);
    }

    @Override
    public Collection<WriteOperation<?>> beforeCommit(ImprovedTransactionData transactionData) throws DeliberateTransactionRollbackException {
        Collection result = transactionData.getAllCreatedNodes().stream().map(createdNode -> new NodeCreated(this.nodeRepresentation((Node)createdNode))).collect(Collectors.toCollection(HashSet::new));
        result.addAll(transactionData.getAllChangedNodes().stream().map(updatedNode -> new NodeUpdated(this.nodeRepresentation((Node)updatedNode.getPrevious()), this.nodeRepresentation((Node)updatedNode.getCurrent()))).collect(Collectors.toList()));
        result.addAll(transactionData.getAllDeletedNodes().stream().map(deletedNode -> new NodeDeleted(this.nodeRepresentation((Node)deletedNode))).collect(Collectors.toList()));
        result.addAll(transactionData.getAllCreatedRelationships().stream().map(createdRelationship -> new RelationshipCreated(this.relationshipRepresentation((Relationship)createdRelationship))).collect(Collectors.toList()));
        result.addAll(transactionData.getAllChangedRelationships().stream().map(updatedRelationship -> new RelationshipUpdated(this.relationshipRepresentation((Relationship)updatedRelationship.getPrevious()), this.relationshipRepresentation((Relationship)updatedRelationship.getCurrent()))).collect(Collectors.toList()));
        result.addAll(transactionData.getAllDeletedRelationships().stream().map(deletedRelationship -> new RelationshipDeleted(this.relationshipRepresentation((Relationship)deletedRelationship))).collect(Collectors.toList()));
        return result;
    }

    protected abstract DetachedRelationship<ID, ? extends DetachedNode<ID>> relationshipRepresentation(Relationship var1);

    protected abstract DetachedNode<ID> nodeRepresentation(Node var1);
}

