/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.schedule;

import com.graphaware.runtime.monitor.DatabaseLoadMonitor;
import com.graphaware.runtime.monitor.RunningWindowAverage;
import com.graphaware.runtime.monitor.StartedTxBasedLoadMonitor;
import com.graphaware.runtime.schedule.ConstantDeltaDelayAdjuster;
import com.graphaware.runtime.schedule.DelayAdjuster;
import com.graphaware.runtime.schedule.TimingStrategy;
import org.neo4j.graphdb.GraphDatabaseService;

public class AdaptiveTimingStrategy
implements TimingStrategy {
    private final long delta;
    private final long defaultDelay;
    private final long minDelay;
    private final long maxDelay;
    private final long busyThreshold;
    private final int maxSamples;
    private final int maxTime;
    private DelayAdjuster delayAdjuster;
    private DatabaseLoadMonitor loadMonitor;
    private long previousDelay = -1L;

    public static AdaptiveTimingStrategy defaultConfiguration() {
        return new AdaptiveTimingStrategy(100L, 2000L, 5L, 5000L, 100L, 200, 2000);
    }

    private AdaptiveTimingStrategy(long delta, long defaultDelay, long minDelay, long maxDelay, long busyThreshold, int maxSamples, int maxTime) {
        this.delta = delta;
        this.defaultDelay = defaultDelay;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.busyThreshold = busyThreshold;
        this.maxSamples = maxSamples;
        this.maxTime = maxTime;
    }

    public AdaptiveTimingStrategy withDelta(long delta) {
        return new AdaptiveTimingStrategy(delta, this.defaultDelay, this.minDelay, this.maxDelay, this.busyThreshold, this.maxSamples, this.maxTime);
    }

    public AdaptiveTimingStrategy withDefaultDelayMillis(long defaultDelay) {
        return new AdaptiveTimingStrategy(this.delta, defaultDelay, this.minDelay, this.maxDelay, this.busyThreshold, this.maxSamples, this.maxTime);
    }

    public AdaptiveTimingStrategy withMinimumDelayMillis(long minDelay) {
        return new AdaptiveTimingStrategy(this.delta, this.defaultDelay, minDelay, this.maxDelay, this.busyThreshold, this.maxSamples, this.maxTime);
    }

    public AdaptiveTimingStrategy withMaximumDelayMillis(long maxDelay) {
        return new AdaptiveTimingStrategy(this.delta, this.defaultDelay, this.minDelay, maxDelay, this.busyThreshold, this.maxSamples, this.maxTime);
    }

    public AdaptiveTimingStrategy withBusyThreshold(int busyThreshold) {
        return new AdaptiveTimingStrategy(this.delta, this.defaultDelay, this.minDelay, this.maxDelay, busyThreshold, this.maxSamples, this.maxTime);
    }

    public AdaptiveTimingStrategy withMaxSamples(int maxSamples) {
        return new AdaptiveTimingStrategy(this.delta, this.defaultDelay, this.minDelay, this.maxDelay, this.busyThreshold, maxSamples, this.maxTime);
    }

    public AdaptiveTimingStrategy withMaxTime(int maxTime) {
        return new AdaptiveTimingStrategy(this.delta, this.defaultDelay, this.minDelay, this.maxDelay, this.busyThreshold, this.maxSamples, maxTime);
    }

    @Override
    public void initialize(GraphDatabaseService database) {
        this.delayAdjuster = new ConstantDeltaDelayAdjuster(this.delta, this.defaultDelay, this.minDelay, this.maxDelay, this.busyThreshold);
        this.loadMonitor = new StartedTxBasedLoadMonitor(database, new RunningWindowAverage(this.maxSamples, this.maxTime));
    }

    @Override
    public long nextDelay(long lastTaskDuration) {
        long newDelay;
        if (this.delayAdjuster == null || this.loadMonitor == null) {
            throw new IllegalStateException("Initialization hasn't been performed, this is a bug.");
        }
        this.previousDelay = newDelay = this.delayAdjuster.determineNextDelay(this.previousDelay, lastTaskDuration, this.loadMonitor.getLoad());
        return newDelay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdaptiveTimingStrategy that = (AdaptiveTimingStrategy)o;
        if (this.busyThreshold != that.busyThreshold) {
            return false;
        }
        if (this.defaultDelay != that.defaultDelay) {
            return false;
        }
        if (this.delta != that.delta) {
            return false;
        }
        if (this.maxDelay != that.maxDelay) {
            return false;
        }
        if (this.maxSamples != that.maxSamples) {
            return false;
        }
        if (this.maxTime != that.maxTime) {
            return false;
        }
        return this.minDelay == that.minDelay;
    }

    public int hashCode() {
        int result = (int)(this.delta ^ this.delta >>> 32);
        result = 31 * result + (int)(this.defaultDelay ^ this.defaultDelay >>> 32);
        result = 31 * result + (int)(this.minDelay ^ this.minDelay >>> 32);
        result = 31 * result + (int)(this.maxDelay ^ this.maxDelay >>> 32);
        result = 31 * result + (int)(this.busyThreshold ^ this.busyThreshold >>> 32);
        result = 31 * result + this.maxSamples;
        result = 31 * result + this.maxTime;
        return result;
    }
}

