/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.schedule;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.util.Pair;
import com.graphaware.runtime.metadata.DefaultTimerDrivenModuleMetadata;
import com.graphaware.runtime.metadata.ModuleMetadataRepository;
import com.graphaware.runtime.metadata.TimerDrivenModuleContext;
import com.graphaware.runtime.module.TimerDrivenModule;
import com.graphaware.runtime.schedule.TaskScheduler;
import com.graphaware.runtime.schedule.TimingStrategy;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class RotatingTaskScheduler
implements TaskScheduler {
    private static final Log LOG = LoggerFactory.getLogger(RotatingTaskScheduler.class);
    private final GraphDatabaseService database;
    private final ModuleMetadataRepository repository;
    private final TimingStrategy timingStrategy;
    private final Map<TimerDrivenModule, TimerDrivenModuleContext> moduleContexts = new LinkedHashMap<TimerDrivenModule, TimerDrivenModuleContext>();
    private Iterator<Map.Entry<TimerDrivenModule, TimerDrivenModuleContext>> moduleContextIterator;
    private final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();

    public RotatingTaskScheduler(GraphDatabaseService database, ModuleMetadataRepository repository, TimingStrategy timingStrategy) {
        this.database = database;
        this.repository = repository;
        this.timingStrategy = timingStrategy;
    }

    @Override
    public <C extends TimerDrivenModuleContext, T extends TimerDrivenModule<C>> void registerModuleAndContext(T module, C context) {
        if (this.moduleContextIterator != null) {
            throw new IllegalStateException("Task scheduler can not accept modules after it has been started. This is a bug.");
        }
        LOG.info("Registering module " + module.getId() + " and its context with the task scheduler.");
        this.moduleContexts.put(module, context);
    }

    @Override
    public void start() {
        if (!this.shouldStart()) {
            LOG.info("There are no timer-driven runtime modules. Not scheduling any tasks.");
            return;
        }
        LOG.info("There are " + this.moduleContexts.size() + " timer-driven runtime modules. Scheduling the first task...");
        this.timingStrategy.initialize(this.database);
        this.scheduleNextTask(-2L);
    }

    protected boolean shouldStart() {
        return !this.moduleContexts.isEmpty();
    }

    @Override
    public void stop() {
        LOG.info("Terminating task scheduler...");
        this.worker.shutdown();
        try {
            this.worker.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Did not manage to finish all tasks in 5 seconds.");
        }
        LOG.info("Task scheduler terminated successfully.");
    }

    private void scheduleNextTask(long lastTaskDuration) {
        long nextDelayMillis = this.timingStrategy.nextDelay(lastTaskDuration);
        LOG.debug("Scheduling next task with a delay of %s ms.", new Object[]{nextDelayMillis});
        this.worker.schedule(this.nextTask(), nextDelayMillis, TimeUnit.MILLISECONDS);
    }

    protected Runnable nextTask() {
        return () -> {
            long totalTime = -1L;
            try {
                LOG.debug("Running a scheduled task...");
                long startTime = System.currentTimeMillis();
                this.runNextTask();
                totalTime = System.currentTimeMillis() - startTime;
                LOG.debug("Successfully completed scheduled task in " + totalTime + " ms");
            }
            catch (Exception e) {
                LOG.warn("Task execution threw an exception: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.scheduleNextTask(totalTime);
            }
        };
    }

    private <C extends TimerDrivenModuleContext, T extends TimerDrivenModule<C>> void runNextTask() {
        if (!this.database.isAvailable(0L)) {
            LOG.warn("Database not available, probably shutting down...");
            return;
        }
        Pair<T, C> moduleAndContext = this.findNextModuleAndContext();
        if (moduleAndContext == null) {
            return;
        }
        TimerDrivenModule module = (TimerDrivenModule)moduleAndContext.first();
        TimerDrivenModuleContext context = (TimerDrivenModuleContext)moduleAndContext.second();
        try (Transaction tx = this.database.beginTx();){
            TimerDrivenModuleContext newContext = module.doSomeWork(context, this.database);
            this.repository.persistModuleMetadata(module, new DefaultTimerDrivenModuleMetadata(newContext));
            this.moduleContexts.put(module, newContext);
            tx.success();
        }
    }

    private <C extends TimerDrivenModuleContext, T extends TimerDrivenModule<C>> Pair<T, C> findNextModuleAndContext() {
        int totalModules = this.moduleContexts.size();
        long now = System.currentTimeMillis();
        for (int i = 0; i < totalModules; ++i) {
            Pair<T, C> candidate = this.nextModuleAndContext();
            if (!this.hasCorrectRole((TimerDrivenModule)candidate.first()) || candidate.second() != null && ((TimerDrivenModuleContext)candidate.second()).earliestNextCall() > now) continue;
            return candidate;
        }
        return null;
    }

    protected boolean hasCorrectRole(TimerDrivenModule<?> module) {
        return true;
    }

    private <C extends TimerDrivenModuleContext, T extends TimerDrivenModule<C>> Pair<T, C> nextModuleAndContext() {
        if (this.moduleContextIterator == null || !this.moduleContextIterator.hasNext()) {
            this.moduleContextIterator = this.moduleContexts.entrySet().iterator();
        }
        Map.Entry<TimerDrivenModule, TimerDrivenModuleContext> entry = this.moduleContextIterator.next();
        return new Pair((Object)entry.getKey(), (Object)entry.getValue());
    }
}

