/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.walk;

import com.graphaware.common.policy.inclusion.NodeInclusionPolicy;
import com.graphaware.common.util.ReservoirSampler;
import com.graphaware.runtime.policy.all.IncludeAllBusinessNodes;
import com.graphaware.runtime.walk.NodeSelector;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class RandomNodeSelector
implements NodeSelector {
    private static final int MAX_EFFICIENT_ATTEMPTS = 10;
    private final NodeInclusionPolicy inclusionPolicy;
    private final RandomDataGenerator random = new RandomDataGenerator();

    public RandomNodeSelector() {
        this(IncludeAllBusinessNodes.getInstance());
    }

    public RandomNodeSelector(NodeInclusionPolicy inclusionPolicy) {
        this.inclusionPolicy = inclusionPolicy;
    }

    @Override
    public Node selectNode(GraphDatabaseService database) {
        Node candidate = this.randomNodeO1(database);
        if (candidate != null) {
            return candidate;
        }
        return this.randomNodeON(database);
    }

    private Node randomNodeO1(GraphDatabaseService database) {
        long highestId = ((RecordStorageEngine)((GraphDatabaseAPI)database).getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getNodeStore().getHighestPossibleIdInUse();
        if (highestId <= 0L) {
            return null;
        }
        for (int i = 0; i < 10; ++i) {
            long randomId = this.random.nextLong(0L, highestId);
            try {
                Node node = database.getNodeById(randomId);
                if (!this.inclusionPolicy.include((Object)node)) continue;
                return node;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private Node randomNodeON(GraphDatabaseService database) {
        ResourceIterable allNodes = database.getAllNodes();
        ReservoirSampler randomSampler = new ReservoirSampler(1);
        for (Node node : allNodes) {
            if (!this.inclusionPolicy.include((Object)node)) continue;
            randomSampler.sample((Object)node);
        }
        if (randomSampler.isEmpty()) {
            return null;
        }
        return (Node)randomSampler.getSamples().iterator().next();
    }
}

