/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.walk;

import com.graphaware.common.policy.inclusion.RelationshipInclusionPolicy;
import com.graphaware.common.util.ReservoirSampler;
import com.graphaware.runtime.policy.all.IncludeAllBusinessRelationships;
import com.graphaware.runtime.walk.RelationshipSelector;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class RandomRelationshipSelector
implements RelationshipSelector {
    private final RelationshipInclusionPolicy relationshipInclusionPolicy;

    public RandomRelationshipSelector() {
        this((RelationshipInclusionPolicy)IncludeAllBusinessRelationships.getInstance());
    }

    public RandomRelationshipSelector(RelationshipInclusionPolicy relationshipInclusionPolicy) {
        this.relationshipInclusionPolicy = relationshipInclusionPolicy;
    }

    @Override
    public Relationship selectRelationship(Node node) {
        ReservoirSampler randomSampler = new ReservoirSampler(1);
        for (Relationship relationship : node.getRelationships()) {
            if (!this.relationshipInclusionPolicy.include(relationship, node)) continue;
            randomSampler.sample((Object)relationship);
        }
        if (randomSampler.isEmpty()) {
            return null;
        }
        return (Relationship)randomSampler.getSamples().iterator().next();
    }
}

