/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.runtime.write;

import com.graphaware.runtime.write.DatabaseWriterType;
import com.graphaware.runtime.write.WritingConfig;
import com.graphaware.writer.neo4j.BatchWriter;
import com.graphaware.writer.neo4j.DefaultWriter;
import com.graphaware.writer.neo4j.Neo4jWriter;
import com.graphaware.writer.neo4j.TxPerTaskWriter;
import org.neo4j.graphdb.GraphDatabaseService;

public class FluentWritingConfig
implements WritingConfig {
    private final DatabaseWriterType writerType;
    private final int queueSize;
    private final int batchSize;

    public static FluentWritingConfig defaultConfiguration() {
        return new FluentWritingConfig(DatabaseWriterType.DEFAULT, 10000, 1000);
    }

    public FluentWritingConfig withWriterType(DatabaseWriterType writerType) {
        return new FluentWritingConfig(writerType, this.queueSize, this.batchSize);
    }

    public FluentWritingConfig withQueueSize(int queueSize) {
        return new FluentWritingConfig(this.writerType, queueSize, this.batchSize);
    }

    public FluentWritingConfig withBatchSize(int batchSize) {
        return new FluentWritingConfig(this.writerType, this.queueSize, batchSize);
    }

    private FluentWritingConfig(DatabaseWriterType writerType, int queueSize, int batchSize) {
        this.writerType = writerType;
        this.queueSize = queueSize;
        this.batchSize = batchSize;
    }

    public Neo4jWriter produceWriter(GraphDatabaseService database) {
        switch (this.writerType) {
            case DEFAULT: {
                return new DefaultWriter(database);
            }
            case SINGLE_THREADED: {
                return new TxPerTaskWriter(database, this.queueSize);
            }
            case BATCH: {
                return new BatchWriter(database, this.queueSize, this.batchSize);
            }
        }
        throw new IllegalStateException("Unknown writer type: " + this.writerType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluentWritingConfig that = (FluentWritingConfig)o;
        if (this.batchSize != that.batchSize) {
            return false;
        }
        if (this.queueSize != that.queueSize) {
            return false;
        }
        return this.writerType == that.writerType;
    }

    public int hashCode() {
        int result = this.writerType.hashCode();
        result = 31 * result + this.queueSize;
        result = 31 * result + this.batchSize;
        return result;
    }
}

