/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.server.foundation.bootstrap;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.ping.GoogleAnalyticsStatsCollector;
import com.graphaware.common.ping.NullStatsCollector;
import com.graphaware.common.ping.StatsCollector;
import com.graphaware.server.foundation.bootstrap.SpringInitializingServletContextListener;
import com.graphaware.server.foundation.bootstrap.WebAppInitializer;
import com.graphaware.server.foundation.context.FoundationRootContextCreator;
import com.graphaware.server.foundation.context.GraphAwareWebContextCreator;
import com.graphaware.server.foundation.context.RootContextCreator;
import com.graphaware.server.foundation.context.WebContextCreator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ArrayUtil;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.web.Jetty9WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.WebApplicationContext;

public class GraphAwareBootstrappingFilter
implements Filter {
    private static final Log LOG = LoggerFactory.getLogger(GraphAwareBootstrappingFilter.class);
    private static final String GA_PACKAGE = "com.graphaware.server";
    private final NeoServer neoServer;
    private final Jetty9WebServer webServer;
    private AbstractApplicationContext rootContext;

    public GraphAwareBootstrappingFilter(NeoServer neoServer, Jetty9WebServer webServer) {
        this.neoServer = neoServer;
        this.webServer = webServer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.rootContext != null) {
            return;
        }
        StatsCollector statsCollector = this.createStatsCollector();
        this.bootstrapGraphAware(filterConfig, statsCollector);
        statsCollector.frameworkStart("all");
    }

    private StatsCollector createStatsCollector() {
        String disable = (String)this.neoServer.getConfig().getRaw().get("com.graphaware.runtime.stats.disable");
        String disabled = (String)this.neoServer.getConfig().getRaw().get("com.graphaware.runtime.stats.disabled");
        if (Boolean.parseBoolean(disable) || Boolean.parseBoolean(disabled)) {
            LOG.info("Google Analytics disabled");
            return NullStatsCollector.getInstance();
        }
        LOG.info("Google Analytics enabled");
        return new GoogleAnalyticsStatsCollector((GraphDatabaseService)this.neoServer.getDatabase().getGraph(), this.neoServer.getConfig());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    public void destroy() {
        if (this.rootContext != null) {
            this.rootContext.close();
            this.rootContext = null;
        }
    }

    private void bootstrapGraphAware(FilterConfig filterConfig, StatsCollector statsCollector) {
        HandlerList handlerList = this.findHandlerList(filterConfig);
        SessionIdManager sessionManager = this.findSessionManager((HandlerCollection)handlerList);
        this.rootContext = this.getRootContextCreator().createContext(this.neoServer, statsCollector);
        this.addGraphAwareHandlers((HandlerCollection)handlerList, sessionManager, (ApplicationContext)this.rootContext, this.neoServer.getConfig());
    }

    private HandlerList findHandlerList(FilterConfig filterConfig) {
        Server server = ((ContextHandler.Context)filterConfig.getServletContext()).getContextHandler().getServer();
        if (RequestLogHandler.class.isAssignableFrom(server.getHandler().getClass())) {
            return (HandlerList)((RequestLogHandler)server.getHandler()).getHandler();
        }
        return (HandlerList)server.getHandler();
    }

    private SessionIdManager findSessionManager(HandlerCollection handlerList) {
        for (Handler h : handlerList.getHandlers()) {
            if (!(h instanceof ServletContextHandler)) continue;
            return ((ServletContextHandler)h).getSessionHandler().getSessionIdManager();
        }
        throw new IllegalStateException("Could not find SessionManager");
    }

    protected RootContextCreator getRootContextCreator() {
        return new FoundationRootContextCreator();
    }

    protected void addGraphAwareHandlers(HandlerCollection handlerList, SessionIdManager sessionManager, ApplicationContext rootContext, Config config) {
        this.prependHandler(handlerList, this.createGraphAwareHandler(sessionManager, rootContext));
    }

    private ServletContextHandler createGraphAwareHandler(SessionIdManager sessionManager, ApplicationContext rootContext) {
        ServletContextHandler handler = this.createNewHandler(sessionManager, this.getContextPath(this.neoServer.getConfig()));
        this.addSpringToHandler(handler, this.getGraphAwareContextCreator(), rootContext, this.neoServer.getConfig());
        this.addDefaultFilters(handler);
        return handler;
    }

    protected final ServletContextHandler createNewHandler(SessionIdManager sessionManager, String contextPath) {
        ServletContextHandler handler = new ServletContextHandler(1);
        this.configureNewHandler(sessionManager, contextPath, handler);
        return handler;
    }

    protected final void configureNewHandler(SessionIdManager sessionManager, String contextPath, ServletContextHandler handler) {
        handler.setContextPath(contextPath);
        handler.getSessionHandler().setSessionIdManager(sessionManager);
        handler.setServer(this.webServer.getJetty());
    }

    protected WebContextCreator getGraphAwareContextCreator() {
        return new GraphAwareWebContextCreator();
    }

    protected final void addSpringToHandler(ServletContextHandler handler, WebContextCreator contextCreator, ApplicationContext rootContext, Config config) {
        this.addSpringToHandler(handler, contextCreator.createWebContext(rootContext, handler, config));
    }

    protected final void addSpringToHandler(ServletContextHandler handler, WebApplicationContext context) {
        handler.addEventListener((EventListener)((Object)new SpringInitializingServletContextListener((WebApplicationInitializer)new WebAppInitializer(context, "graphaware" + handler.getContextPath()), (ServletContext)handler.getServletContext())));
    }

    protected final void addDefaultFilters(ServletContextHandler context) {
        try {
            Method m = Jetty9WebServer.class.getDeclaredMethod("addFiltersTo", ServletContextHandler.class);
            m.setAccessible(true);
            m.invoke((Object)this.webServer, context);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void prependHandler(HandlerCollection handlerList, ServletContextHandler handler) {
        handlerList.setHandlers((Handler[])ArrayUtil.prependToArray((Object)handler, (Object[])handlerList.getHandlers(), Handler.class));
    }

    private String getContextPath(Config config) {
        for (ThirdPartyJaxRsPackage rsPackage : (List)config.get(ServerSettings.third_party_packages)) {
            if (!rsPackage.getPackageName().equals(this.getPackage())) continue;
            String path = rsPackage.getMountPoint();
            if (StringUtils.isNotBlank((String)path)) {
                LOG.info("Mounting GraphAware Framework at %s", new Object[]{path});
                return path;
            }
            throw new IllegalArgumentException("Illegal GraphAware mount point: " + path);
        }
        throw new IllegalStateException("No mount point for GraphAware");
    }

    protected String getPackage() {
        return GA_PACKAGE;
    }
}

