/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.server.foundation.bootstrap;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.server.foundation.bootstrap.GraphAwareBootstrappingFilter;
import com.graphaware.server.tx.LongRunningTransactionFilter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.Filter;
import javax.ws.rs.Path;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.SPIPluginLifecycle;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.server.web.WebServer;

@Path(value="/")
public class GraphAwareServerBootstrapper
implements SPIPluginLifecycle {
    private static final Log LOG = LoggerFactory.getLogger(GraphAwareServerBootstrapper.class);

    public Collection<Injectable<?>> start(NeoServer neoServer) {
        LOG.info("started");
        this.addFilters(neoServer);
        return Collections.emptyList();
    }

    private void addFilters(NeoServer neoServer) {
        this.addFilters(neoServer, this.getWebServer(neoServer));
    }

    protected void addFilters(NeoServer neoServer, Jetty9WebServer webServer) {
        webServer.addFilter((Filter)this.createBootstrappingFilter(neoServer, webServer), "/*");
        webServer.addFilter((Filter)this.createTransactionFilter(neoServer), "/*");
    }

    private Jetty9WebServer getWebServer(NeoServer neoServer) {
        if (neoServer instanceof AbstractNeoServer) {
            WebServer webServer = ((AbstractNeoServer)neoServer).getWebServer();
            if (webServer instanceof Jetty9WebServer) {
                return (Jetty9WebServer)webServer;
            }
            throw new IllegalStateException("Server is not Jetty9WebServer");
        }
        throw new IllegalStateException("Server is not an AbstractNeoServer");
    }

    protected GraphAwareBootstrappingFilter createBootstrappingFilter(NeoServer neoServer, Jetty9WebServer webServer) {
        return new GraphAwareBootstrappingFilter(neoServer, webServer);
    }

    private LongRunningTransactionFilter createTransactionFilter(NeoServer neoServer) {
        return new LongRunningTransactionFilter(this.getTransactionFacade(neoServer));
    }

    public void stop() {
        LOG.info("stopped");
    }

    public Collection<Injectable<?>> start(GraphDatabaseService graphDatabaseService, Configuration configuration) {
        throw new UnsupportedOperationException("Attempted to start the GraphAware Framework in an unsupported way");
    }

    private TransactionFacade getTransactionFacade(NeoServer neoServer) {
        try {
            Field tfField = AbstractNeoServer.class.getDeclaredField("transactionFacade");
            tfField.setAccessible(true);
            return (TransactionFacade)tfField.get(neoServer);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

