/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.server.foundation.context;

import com.graphaware.common.ping.StatsCollector;
import com.graphaware.runtime.GraphAwareRuntime;
import com.graphaware.runtime.RuntimeRegistry;
import com.graphaware.server.foundation.context.RootContextCreator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.server.NeoServer;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class FoundationRootContextCreator
implements RootContextCreator {
    @Override
    public AbstractApplicationContext createContext(NeoServer neoServer, StatsCollector statsCollector) {
        GenericApplicationContext parent = new GenericApplicationContext();
        parent.registerShutdownHook();
        parent.getBeanFactory().registerSingleton("database", (Object)neoServer.getDatabase().getGraph());
        parent.getBeanFactory().registerSingleton("procedures", neoServer.getDatabase().getGraph().getDependencyResolver().resolveDependency(Procedures.class));
        parent.getBeanFactory().registerSingleton("getStatsCollector", (Object)statsCollector);
        GraphAwareRuntime runtime = RuntimeRegistry.getRuntime((GraphDatabaseService)neoServer.getDatabase().getGraph());
        if (runtime != null) {
            runtime.waitUntilStarted();
            parent.getBeanFactory().registerSingleton("databaseWriter", (Object)runtime.getDatabaseWriter());
        }
        parent.refresh();
        return parent;
    }
}

