/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.server.foundation.context;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.server.foundation.context.BaseWebContextCreator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class GraphAwareWebContextCreator
extends BaseWebContextCreator {
    private static final Log LOG = LoggerFactory.getLogger(GraphAwareWebContextCreator.class);
    private static final String GA_API_PACKAGE_SCAN_SETTING = "com.graphaware.server.api.scan";
    private static final String GA_API_STATS_DISABLE_SETTING_LEGACY = "com.graphaware.server.stats.disable";
    private static final String GA_API_STATS_DISABLE_SETTING = "com.graphaware.server.stats.disabled";
    private static final String[] GA_API_PACKAGE_SCAN_DEFAULT = new String[]{"com.**.graphaware.**", "org.**.graphaware.**", "net.**.graphaware.**"};
    private static final String GA_STATS_PACKAGE = "com.graphaware.server.foundation.stats";

    @Override
    protected void registerConfigClasses(AnnotationConfigWebApplicationContext context, Config config) {
        this.configureStatsCollector(context, config);
        context.scan(this.addStatsPackage(this.getPackagesToScan(config)));
    }

    private String[] addStatsPackage(String[] packagesToScan) {
        packagesToScan = (String[])ArrayUtils.add((Object[])packagesToScan, (Object)GA_STATS_PACKAGE);
        return packagesToScan;
    }

    private void configureStatsCollector(AnnotationConfigWebApplicationContext context, Config config) {
        if (Boolean.valueOf(config.getRaw().getOrDefault(GA_API_STATS_DISABLE_SETTING_LEGACY, "false")).booleanValue()) {
            context.getEnvironment().addActiveProfile("stats-null");
        } else if (Boolean.valueOf(config.getRaw().getOrDefault(GA_API_STATS_DISABLE_SETTING, "false")).booleanValue()) {
            context.getEnvironment().addActiveProfile("stats-null");
        } else {
            context.getEnvironment().addActiveProfile("stats-google");
        }
    }

    private String[] getPackagesToScan(Config config) {
        if (config.getRaw().containsKey(GA_API_PACKAGE_SCAN_SETTING)) {
            String packageExpression = (String)config.getRaw().get(GA_API_PACKAGE_SCAN_SETTING);
            if (StringUtils.isNotBlank((String)packageExpression)) {
                LOG.info("Will try to scan the following packages: " + packageExpression);
                return packageExpression.split(",");
            }
            LOG.warn("Invalid expression for packages to scan, will use default...");
        }
        LOG.info("Will try to scan the following packages: " + ArrayUtils.toString((Object)GA_API_PACKAGE_SCAN_DEFAULT));
        return GA_API_PACKAGE_SCAN_DEFAULT;
    }
}

