/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.server.tx;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.server.tx.LongRunningTransaction;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.logging.Log;
import org.neo4j.server.rest.transactional.GraphAwareLongRunningTransaction;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.transactional.error.TransactionLifecycleException;

public class LongRunningTransactionFilter
implements Filter {
    private static final Log LOG = LoggerFactory.getLogger(LongRunningTransactionFilter.class);
    private static final String TX_HEADER = "_GA_TX_ID";
    private final TransactionFacade transactionFacade;

    public LongRunningTransactionFilter(TransactionFacade transactionFacade) {
        this.transactionFacade = transactionFacade;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.debug("Initializing " + LongRunningTransaction.class.getName());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LongRunningTransaction longRunningTransaction = null;
        String txId = ((HttpServletRequest)request).getHeader(TX_HEADER);
        if (txId != null) {
            LOG.debug("Trying to participate in a long-running transaction ID: " + txId);
            try {
                long txIdAsLong = Long.parseLong(txId);
                TransactionHandle transactionHandle = this.transactionFacade.findTransactionHandle(txIdAsLong);
                longRunningTransaction = new GraphAwareLongRunningTransaction(transactionHandle);
                longRunningTransaction.resume();
                LOG.debug("Transaction " + txId + " resumed.");
            }
            catch (TransactionLifecycleException e) {
                LOG.warn("Transaction " + txId + " could not be resumed.", (Throwable)e);
                Neo4jError error = e.toNeo4jError();
                response.reset();
                ((HttpServletResponse)response).setStatus(400);
                response.getWriter().append(error.getMessage());
                response.getWriter().append(error.getStackTraceAsString());
                return;
            }
            catch (RuntimeException e) {
                LOG.warn("Transaction " + txId + " could not be resumed.", (Throwable)e);
                response.reset();
                ((HttpServletResponse)response).setStatus(400);
                response.getWriter().append(e.getMessage());
                return;
            }
        }
        chain.doFilter(request, response);
        if (longRunningTransaction != null) {
            LOG.debug("Suspending transaction " + txId);
            longRunningTransaction.suspend();
        }
    }

    public void destroy() {
        LOG.debug("Destroying " + LongRunningTransaction.class.getName());
    }
}

