/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import com.graphaware.server.tx.LongRunningTransaction;
import java.lang.reflect.Field;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;

public class GraphAwareLongRunningTransaction
implements LongRunningTransaction {
    private final TransactionHandle transactionHandle;
    private final TransitionalTxManagementKernelTransaction transaction;
    private final TransactionRegistry registry;
    private final long id;

    public GraphAwareLongRunningTransaction(TransactionHandle transactionHandle) {
        this.transactionHandle = transactionHandle;
        try {
            Field contextField = transactionHandle.getClass().getDeclaredField("context");
            contextField.setAccessible(true);
            this.transaction = (TransitionalTxManagementKernelTransaction)contextField.get(transactionHandle);
            Field registryField = transactionHandle.getClass().getDeclaredField("registry");
            registryField.setAccessible(true);
            this.registry = (TransactionRegistry)registryField.get(transactionHandle);
            Field idField = transactionHandle.getClass().getDeclaredField("id");
            idField.setAccessible(true);
            this.id = (Long)idField.get(transactionHandle);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void resume() {
        this.transaction.resumeSinceTransactionsAreStillThreadBound();
    }

    @Override
    public void suspend() {
        this.transaction.suspendSinceTransactionsAreStillThreadBound();
        this.registry.release(this.id, this.transactionHandle);
    }
}

