/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.api;

import com.graphaware.common.policy.inclusion.InclusionPolicies;
import com.graphaware.common.policy.inclusion.none.IncludeNoNodeProperties;
import com.graphaware.common.policy.inclusion.none.IncludeNoNodes;
import com.graphaware.common.policy.inclusion.none.IncludeNoRelationshipProperties;
import com.graphaware.common.policy.inclusion.none.IncludeNoRelationships;
import com.graphaware.tx.event.improved.api.ImprovedTransactionData;
import com.graphaware.tx.event.improved.data.BaseImprovedTransactionData;
import com.graphaware.tx.event.improved.data.NodeTransactionData;
import com.graphaware.tx.event.improved.data.RelationshipTransactionData;
import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import com.graphaware.tx.event.improved.data.filtered.FilteredNodeTransactionData;
import com.graphaware.tx.event.improved.data.filtered.FilteredRelationshipTransactionData;

public class FilteredTransactionData
extends BaseImprovedTransactionData
implements ImprovedTransactionData,
TransactionDataContainer {
    private final InclusionPolicies inclusionPolicies;
    private final NodeTransactionData nodeTransactionData;
    private final RelationshipTransactionData relationshipTransactionData;

    public FilteredTransactionData(TransactionDataContainer transactionDataContainer, InclusionPolicies inclusionPolicies) {
        this.inclusionPolicies = inclusionPolicies;
        this.nodeTransactionData = new FilteredNodeTransactionData(transactionDataContainer.getNodeTransactionData(), inclusionPolicies);
        this.relationshipTransactionData = new FilteredRelationshipTransactionData(transactionDataContainer.getRelationshipTransactionData(), inclusionPolicies);
    }

    @Override
    public NodeTransactionData getNodeTransactionData() {
        return this.nodeTransactionData;
    }

    @Override
    public RelationshipTransactionData getRelationshipTransactionData() {
        return this.relationshipTransactionData;
    }

    @Override
    public boolean mutationsOccurred() {
        return !this.inclusionPolicies.getNodeInclusionPolicy().equals(IncludeNoNodes.getInstance()) && !this.getAllCreatedNodes().isEmpty() || !this.inclusionPolicies.getRelationshipInclusionPolicy().equals(IncludeNoRelationships.getInstance()) && !this.getAllCreatedRelationships().isEmpty() || !this.inclusionPolicies.getNodeInclusionPolicy().equals(IncludeNoNodes.getInstance()) && !this.getAllDeletedNodes().isEmpty() || !this.inclusionPolicies.getRelationshipInclusionPolicy().equals(IncludeNoRelationships.getInstance()) && !this.getAllDeletedRelationships().isEmpty() || !this.inclusionPolicies.getNodePropertyInclusionPolicy().equals(IncludeNoNodeProperties.getInstance()) && !this.getAllChangedNodes().isEmpty() || !this.inclusionPolicies.getRelationshipPropertyInclusionPolicy().equals(IncludeNoRelationshipProperties.getInstance()) && !this.getAllChangedRelationships().isEmpty();
    }
}

