/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.data.filtered;

import com.graphaware.common.policy.inclusion.InclusionPolicies;
import com.graphaware.common.policy.inclusion.PropertyContainerInclusionPolicy;
import com.graphaware.common.policy.inclusion.PropertyInclusionPolicy;
import com.graphaware.common.policy.inclusion.none.IncludeNoProperties;
import com.graphaware.common.policy.inclusion.none.IncludeNone;
import com.graphaware.common.util.Change;
import com.graphaware.tx.event.improved.data.PropertyContainerTransactionData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.neo4j.graphdb.PropertyContainer;

public abstract class FilteredPropertyContainerTransactionData<T extends PropertyContainer> {
    protected final InclusionPolicies policies;

    protected FilteredPropertyContainerTransactionData(InclusionPolicies policies) {
        this.policies = policies;
    }

    protected abstract PropertyContainerTransactionData<T> getWrapped();

    protected abstract PropertyContainerInclusionPolicy<T> getPropertyContainerInclusionPolicy();

    protected abstract PropertyInclusionPolicy<T> getPropertyInclusionPolicy();

    protected abstract T filtered(T var1);

    public boolean hasBeenCreated(T container) {
        return this.getWrapped().hasBeenCreated(container);
    }

    public Collection<T> getAllCreated() {
        if (this.getPropertyContainerInclusionPolicy() instanceof IncludeNone) {
            return Collections.emptySet();
        }
        return this.filterPropertyContainers(this.getWrapped().getAllCreated());
    }

    public boolean hasBeenDeleted(T container) {
        return this.getWrapped().hasBeenDeleted(container);
    }

    public T getDeleted(T container) {
        return this.filtered(this.getWrapped().getDeleted(container));
    }

    public Collection<T> getAllDeleted() {
        if (this.getPropertyContainerInclusionPolicy() instanceof IncludeNone) {
            return Collections.emptySet();
        }
        return this.filterPropertyContainers(this.getWrapped().getAllDeleted());
    }

    public boolean hasBeenChanged(T container) {
        return this.getWrapped().hasBeenChanged(container);
    }

    public Change<T> getChanged(T container) {
        return this.filteredChange(this.getWrapped().getChanged(container));
    }

    public Collection<Change<T>> getAllChanged() {
        if (this.getPropertyContainerInclusionPolicy() instanceof IncludeNone) {
            return Collections.emptySet();
        }
        return this.filterChangedPropertyContainers(this.getWrapped().getAllChanged());
    }

    public boolean hasPropertyBeenCreated(T container, String key) {
        return this.getWrapped().hasPropertyBeenCreated(container, key);
    }

    public Map<String, Object> createdProperties(T container) {
        if (this.getPropertyInclusionPolicy() instanceof IncludeNoProperties) {
            return Collections.emptyMap();
        }
        return this.filterProperties(this.getWrapped().createdProperties(container), container);
    }

    public boolean hasPropertyBeenDeleted(T container, String key) {
        return this.getWrapped().hasPropertyBeenDeleted(container, key);
    }

    public Map<String, Object> deletedProperties(T container) {
        if (this.getPropertyInclusionPolicy() instanceof IncludeNoProperties) {
            return Collections.emptyMap();
        }
        return this.filterProperties(this.getWrapped().deletedProperties(container), container);
    }

    public Map<String, Object> propertiesOfDeletedContainer(T container) {
        if (this.getPropertyInclusionPolicy() instanceof IncludeNoProperties) {
            return Collections.emptyMap();
        }
        return this.filterProperties(this.getWrapped().propertiesOfDeletedContainer(container), container);
    }

    public boolean hasPropertyBeenChanged(T container, String key) {
        return this.getWrapped().hasPropertyBeenChanged(container, key);
    }

    public Map<String, Change<Object>> changedProperties(T container) {
        if (this.getPropertyInclusionPolicy() instanceof IncludeNoProperties) {
            return Collections.emptyMap();
        }
        return this.filterProperties(this.getWrapped().changedProperties(container), container);
    }

    protected final Collection<T> filterPropertyContainers(Collection<T> toFilter) {
        HashSet<PropertyContainer> result = new HashSet<PropertyContainer>();
        for (PropertyContainer candidate : toFilter) {
            if (!this.getPropertyContainerInclusionPolicy().include((Object)candidate)) continue;
            result.add(this.filtered(candidate));
        }
        return result;
    }

    protected final Collection<Change<T>> filterChangedPropertyContainers(Collection<Change<T>> toFilter) {
        HashSet<Change<T>> result = new HashSet<Change<T>>();
        for (Change<T> candidate : toFilter) {
            if (!this.include(candidate) || !this.hasChanged(candidate)) continue;
            result.add(this.filteredChange(candidate));
        }
        return result;
    }

    private boolean include(Change<T> candidate) {
        return this.getPropertyContainerInclusionPolicy().include(candidate.getPrevious()) || this.getPropertyContainerInclusionPolicy().include(candidate.getCurrent());
    }

    protected boolean hasChanged(Change<T> candidate) {
        return !this.createdProperties((PropertyContainer)candidate.getPrevious()).isEmpty() || !this.deletedProperties((PropertyContainer)candidate.getPrevious()).isEmpty() || !this.changedProperties((PropertyContainer)candidate.getPrevious()).isEmpty();
    }

    protected final <V> Map<String, V> filterProperties(Map<String, V> properties, T container) {
        HashMap<String, V> result = new HashMap<String, V>();
        for (Map.Entry<String, V> entry : properties.entrySet()) {
            if (!this.getPropertyInclusionPolicy().include(entry.getKey(), container)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected final Change<T> filteredChange(Change<T> change) {
        return new Change((Object)this.filtered((PropertyContainer)change.getPrevious()), (Object)this.filtered((PropertyContainer)change.getCurrent()));
    }
}

