/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.data.lazy;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.tx.event.improved.data.NodeTransactionData;
import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import com.graphaware.tx.event.improved.data.lazy.LazyPropertyContainerTransactionData;
import com.graphaware.tx.event.improved.propertycontainer.snapshot.NodeSnapshot;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.logging.Log;

public class LazyNodeTransactionData
extends LazyPropertyContainerTransactionData<Node>
implements NodeTransactionData {
    private static final Log LOG = LoggerFactory.getLogger(LazyNodeTransactionData.class);
    private final TransactionData transactionData;
    private final TransactionDataContainer transactionDataContainer;
    private Map<Long, Set<Label>> assignedLabels = null;
    private Map<Long, Set<Label>> removedLabels = null;
    private Map<Long, Set<Label>> deletedNodeLabels = null;

    public LazyNodeTransactionData(TransactionData transactionData, TransactionDataContainer transactionDataContainer) {
        this.transactionData = transactionData;
        this.transactionDataContainer = transactionDataContainer;
    }

    @Override
    protected Node oldSnapshot(Node original) {
        return new NodeSnapshot(original, this.transactionDataContainer);
    }

    @Override
    protected Node newSnapshot(Node original) {
        return original;
    }

    @Override
    protected Iterable<Node> created() {
        return this.transactionData.createdNodes();
    }

    @Override
    protected Iterable<Node> deleted() {
        return this.transactionData.deletedNodes();
    }

    @Override
    protected Iterable<PropertyEntry<Node>> assignedProperties() {
        return this.transactionData.assignedNodeProperties();
    }

    @Override
    protected Iterable<PropertyEntry<Node>> removedProperties() {
        return this.transactionData.removedNodeProperties();
    }

    @Override
    public boolean hasLabelBeenAssigned(Node node, Label label) {
        this.initializeChanged();
        if (!this.hasBeenChanged(node)) {
            return false;
        }
        if (!this.assignedLabels.containsKey(node.getId())) {
            return false;
        }
        return this.assignedLabels.get(node.getId()).contains(label);
    }

    @Override
    public Set<Label> assignedLabels(Node node) {
        this.initializeChanged();
        if (!this.hasBeenChanged(node)) {
            LOG.warn(node + " has not been changed but the caller thinks it should have assigned labels.");
            return Collections.emptySet();
        }
        if (!this.assignedLabels.containsKey(node.getId())) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.assignedLabels.get(node.getId()));
    }

    @Override
    public boolean hasLabelBeenRemoved(Node node, Label label) {
        this.initializeChanged();
        if (!this.hasBeenChanged(node)) {
            LOG.warn(node + " has not been changed but the caller thinks it should have removed labels.");
            return false;
        }
        if (!this.removedLabels.containsKey(node.getId())) {
            return false;
        }
        return this.removedLabels.get(node.getId()).contains(label);
    }

    @Override
    public Set<Label> removedLabels(Node node) {
        this.initializeChanged();
        if (!this.hasBeenChanged(node)) {
            LOG.warn(node + " has not been changed but the caller thinks it should have removed labels.");
            return Collections.emptySet();
        }
        if (!this.removedLabels.containsKey(node.getId())) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.removedLabels.get(node.getId()));
    }

    @Override
    public Set<Label> labelsOfDeletedNode(Node node) {
        this.initializeChanged();
        if (!this.hasBeenDeleted(node)) {
            LOG.error(node + " has not been deleted but the caller thinks it has! This is a bug.");
            throw new IllegalStateException(node + " has not been deleted but the caller thinks it has! This is a bug.");
        }
        if (!this.deletedNodeLabels.containsKey(node.getId())) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.deletedNodeLabels.get(node.getId()));
    }

    @Override
    protected void doInitializeChanged() {
        Node node;
        this.assignedLabels = new HashMap<Long, Set<Label>>();
        this.removedLabels = new HashMap<Long, Set<Label>>();
        this.deletedNodeLabels = new HashMap<Long, Set<Label>>();
        HashMap<Long, Node> potentiallyChangedNodes = new HashMap<Long, Node>();
        for (LabelEntry labelEntry : this.transactionData.assignedLabels()) {
            node = labelEntry.node();
            if (this.hasBeenCreated(node)) continue;
            if (!this.assignedLabels.containsKey(node.getId())) {
                this.assignedLabels.put(node.getId(), new HashSet());
            }
            this.assignedLabels.get(node.getId()).add(labelEntry.label());
            potentiallyChangedNodes.put(node.getId(), node);
        }
        for (LabelEntry labelEntry : this.transactionData.removedLabels()) {
            node = labelEntry.node();
            if (this.hasBeenDeleted(node)) {
                if (!this.deletedNodeLabels.containsKey(node.getId())) {
                    this.deletedNodeLabels.put(node.getId(), new HashSet());
                }
                this.deletedNodeLabels.get(node.getId()).add(labelEntry.label());
                continue;
            }
            if (!this.removedLabels.containsKey(node.getId())) {
                this.removedLabels.put(node.getId(), new HashSet());
            }
            this.removedLabels.get(node.getId()).add(labelEntry.label());
            potentiallyChangedNodes.put(node.getId(), node);
        }
        for (Long nodeId : this.assignedLabels.keySet()) {
            this.registerChange((PropertyContainer)potentiallyChangedNodes.get(nodeId));
        }
        for (Long nodeId : this.removedLabels.keySet()) {
            this.registerChange((PropertyContainer)potentiallyChangedNodes.get(nodeId));
        }
    }
}

