/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.data.lazy;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.util.Change;
import com.graphaware.common.util.PropertyContainerUtils;
import com.graphaware.tx.event.improved.data.PropertyContainerTransactionData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.logging.Log;

public abstract class LazyPropertyContainerTransactionData<T extends PropertyContainer>
implements PropertyContainerTransactionData<T> {
    private static final Log LOG = LoggerFactory.getLogger(LazyPropertyContainerTransactionData.class);
    private Map<Long, T> created = null;
    private Map<Long, T> deleted = null;
    private Map<Long, Change<T>> changed = null;
    private Map<Long, Map<String, Object>> createdProperties = null;
    private Map<Long, Map<String, Object>> deletedProperties = null;
    private Map<Long, Map<String, Change<Object>>> changedProperties = null;
    private Map<Long, Map<String, Object>> deletedContainersProperties = null;

    protected abstract T oldSnapshot(T var1);

    protected abstract T newSnapshot(T var1);

    @Override
    public boolean hasBeenCreated(T container) {
        this.initializeCreated();
        return this.created.containsKey(PropertyContainerUtils.id(container));
    }

    @Override
    public Collection<T> getAllCreated() {
        this.initializeCreated();
        return Collections.unmodifiableCollection(this.created.values());
    }

    private void initializeCreated() {
        if (this.created == null) {
            this.created = new HashMap<Long, T>();
            for (PropertyContainer created : this.created()) {
                this.created.put(PropertyContainerUtils.id((PropertyContainer)created), this.newSnapshot(created));
            }
        }
    }

    protected abstract Iterable<T> created();

    @Override
    public boolean hasBeenDeleted(T container) {
        this.initializeDeleted();
        return this.deleted.containsKey(PropertyContainerUtils.id(container));
    }

    @Override
    public T getDeleted(T container) {
        this.initializeDeleted();
        if (!this.hasBeenDeleted(container)) {
            throw new IllegalArgumentException(container + " has not been deleted!");
        }
        return (T)((PropertyContainer)this.deleted.get(PropertyContainerUtils.id(container)));
    }

    @Override
    public Collection<T> getAllDeleted() {
        this.initializeDeleted();
        return Collections.unmodifiableCollection(this.deleted.values());
    }

    private void initializeDeleted() {
        if (this.deleted == null) {
            this.deleted = new HashMap<Long, T>();
            for (PropertyContainer deleted : this.deleted()) {
                this.deleted.put(PropertyContainerUtils.id((PropertyContainer)deleted), this.oldSnapshot(deleted));
            }
        }
    }

    protected abstract Iterable<T> deleted();

    @Override
    public boolean hasBeenChanged(T container) {
        this.initializeChanged();
        return this.changedContainsKey(container);
    }

    @Override
    public Change<T> getChanged(T container) {
        this.initializeChanged();
        if (!this.hasBeenChanged(container)) {
            throw new IllegalArgumentException(container + " has not been changed!");
        }
        return this.changed.get(PropertyContainerUtils.id(container));
    }

    @Override
    public Collection<Change<T>> getAllChanged() {
        this.initializeChanged();
        return Collections.unmodifiableCollection(this.changed.values());
    }

    protected void initializeChanged() {
        this.initializeCreated();
        this.initializeDeleted();
        if (this.changed == null) {
            PropertyContainer candidate;
            this.changed = new HashMap<Long, Change<T>>();
            for (PropertyEntry<T> propertyEntry : this.assignedProperties()) {
                if (this.hasNotActuallyChanged(propertyEntry) || this.hasBeenCreated(candidate = propertyEntry.entity())) continue;
                this.registerChange(candidate);
            }
            for (PropertyEntry<T> propertyEntry : this.removedProperties()) {
                candidate = propertyEntry.entity();
                if (this.hasBeenDeleted(candidate)) continue;
                this.registerChange(candidate);
            }
            this.doInitializeChanged();
        }
    }

    protected void doInitializeChanged() {
    }

    protected void registerChange(T candidate) {
        if (!this.changedContainsKey(candidate)) {
            Change<T> change = this.createChangeObject(candidate);
            this.changed.put(PropertyContainerUtils.id(candidate), change);
        }
    }

    protected boolean changedContainsKey(T candidate) {
        return this.changed.containsKey(PropertyContainerUtils.id(candidate));
    }

    protected Change<T> createChangeObject(T candidate) {
        return new Change(this.oldSnapshot(candidate), this.newSnapshot(candidate));
    }

    protected abstract Iterable<PropertyEntry<T>> assignedProperties();

    protected abstract Iterable<PropertyEntry<T>> removedProperties();

    @Override
    public boolean hasPropertyBeenCreated(T container, String key) {
        this.initializeProperties();
        if (!this.hasBeenChanged(container)) {
            LOG.warn(container + " has not been changed but the caller thinks it should have created properties.");
            return false;
        }
        if (!this.createdProperties.containsKey(PropertyContainerUtils.id(container))) {
            return false;
        }
        return this.createdProperties.get(PropertyContainerUtils.id(container)).containsKey(key);
    }

    @Override
    public Map<String, Object> createdProperties(T container) {
        this.initializeProperties();
        if (!this.hasBeenChanged(container)) {
            LOG.warn(container + " has not been changed but the caller thinks it should have created properties.");
            return Collections.emptyMap();
        }
        if (!this.createdProperties.containsKey(PropertyContainerUtils.id(container))) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.createdProperties.get(PropertyContainerUtils.id(container)));
    }

    @Override
    public boolean hasPropertyBeenDeleted(T container, String key) {
        this.initializeProperties();
        if (!this.hasBeenChanged(container)) {
            LOG.warn(container + " has not been changed but the caller thinks it should have deleted properties.");
            return false;
        }
        if (!this.deletedProperties.containsKey(PropertyContainerUtils.id(container))) {
            return false;
        }
        return this.deletedProperties.get(PropertyContainerUtils.id(container)).containsKey(key);
    }

    @Override
    public Map<String, Object> deletedProperties(T container) {
        this.initializeProperties();
        if (!this.hasBeenChanged(container)) {
            LOG.warn(container + " has not been changed but the caller thinks it should have deleted properties.");
            return Collections.emptyMap();
        }
        if (!this.deletedProperties.containsKey(PropertyContainerUtils.id(container))) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.deletedProperties.get(PropertyContainerUtils.id(container)));
    }

    @Override
    public Map<String, Object> propertiesOfDeletedContainer(T container) {
        this.initializeProperties();
        if (!this.hasBeenDeleted(container)) {
            LOG.error(container + " has not been deleted but the caller thinks it has! This is a bug.");
            throw new IllegalStateException(container + " has not been deleted but the caller thinks it has! This is a bug.");
        }
        if (!this.deletedContainersProperties.containsKey(PropertyContainerUtils.id(container))) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.deletedContainersProperties.get(PropertyContainerUtils.id(container)));
    }

    @Override
    public boolean hasPropertyBeenChanged(T container, String key) {
        this.initializeProperties();
        if (!this.hasBeenChanged(container)) {
            LOG.warn(container + " has not been changed but the caller thinks it should have changed properties.");
            return false;
        }
        if (!this.changedProperties.containsKey(PropertyContainerUtils.id(container))) {
            return false;
        }
        return this.changedProperties.get(PropertyContainerUtils.id(container)).containsKey(key);
    }

    @Override
    public Map<String, Change<Object>> changedProperties(T container) {
        this.initializeProperties();
        if (!this.hasBeenChanged(container)) {
            LOG.warn(container + " has not been changed but the caller thinks it should have changed properties.");
            return Collections.emptyMap();
        }
        if (!this.changedProperties.containsKey(PropertyContainerUtils.id(container))) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.changedProperties.get(PropertyContainerUtils.id(container)));
    }

    private void initializeProperties() {
        PropertyContainer container;
        if (this.createdProperties != null) {
            assert (this.changedProperties != null);
            assert (this.deletedProperties != null);
            assert (this.deletedContainersProperties != null);
            return;
        }
        this.initializeChanged();
        this.createdProperties = new HashMap<Long, Map<String, Object>>();
        this.deletedProperties = new HashMap<Long, Map<String, Object>>();
        this.changedProperties = new HashMap<Long, Map<String, Change<Object>>>();
        this.deletedContainersProperties = new HashMap<Long, Map<String, Object>>();
        for (PropertyEntry<T> propertyEntry : this.assignedProperties()) {
            container = propertyEntry.entity();
            if (this.hasBeenCreated(container) || this.hasNotActuallyChanged(propertyEntry)) continue;
            if (propertyEntry.previouslyCommitedValue() == null) {
                if (!this.createdProperties.containsKey(PropertyContainerUtils.id((PropertyContainer)container))) {
                    this.createdProperties.put(PropertyContainerUtils.id((PropertyContainer)container), new HashMap());
                }
                this.createdProperties.get(PropertyContainerUtils.id((PropertyContainer)container)).put(propertyEntry.key(), propertyEntry.value());
                continue;
            }
            if (!this.changedProperties.containsKey(PropertyContainerUtils.id((PropertyContainer)container))) {
                this.changedProperties.put(PropertyContainerUtils.id((PropertyContainer)container), new HashMap());
            }
            this.changedProperties.get(PropertyContainerUtils.id((PropertyContainer)container)).put(propertyEntry.key(), (Change<Object>)new Change(propertyEntry.previouslyCommitedValue(), propertyEntry.value()));
        }
        for (PropertyEntry<T> propertyEntry : this.removedProperties()) {
            container = propertyEntry.entity();
            if (this.deleted.containsKey(PropertyContainerUtils.id((PropertyContainer)container))) {
                if (!this.deletedContainersProperties.containsKey(PropertyContainerUtils.id((PropertyContainer)container))) {
                    this.deletedContainersProperties.put(PropertyContainerUtils.id((PropertyContainer)container), new HashMap());
                }
                this.deletedContainersProperties.get(PropertyContainerUtils.id((PropertyContainer)container)).put(propertyEntry.key(), propertyEntry.previouslyCommitedValue());
                continue;
            }
            if (!this.changedContainsKey(container)) {
                throw new IllegalStateException(container + " seems to have not been deleted or changed, this is a bug");
            }
            assert (this.changedContainsKey(container));
            if (!this.deletedProperties.containsKey(PropertyContainerUtils.id((PropertyContainer)container))) {
                this.deletedProperties.put(PropertyContainerUtils.id((PropertyContainer)container), new HashMap());
            }
            this.deletedProperties.get(PropertyContainerUtils.id((PropertyContainer)container)).put(propertyEntry.key(), propertyEntry.previouslyCommitedValue());
        }
    }

    private boolean hasNotActuallyChanged(PropertyEntry<T> propertyEntry) {
        return propertyEntry.previouslyCommitedValue() != null && propertyEntry.previouslyCommitedValue().equals(propertyEntry.value());
    }
}

