/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.propertycontainer.filtered;

import com.graphaware.common.policy.inclusion.PropertyInclusionPolicy;
import java.util.Iterator;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class FilteredPropertyKeyIterator<T extends PropertyContainer>
extends PrefetchingIterator<String>
implements Iterable<String> {
    private final Iterator<String> wrappedIterator;
    private final T wrappedPropertyContainer;
    private final PropertyInclusionPolicy<T> propertyInclusionPolicy;

    public FilteredPropertyKeyIterator(Iterable<String> wrappedIterator, T wrappedPropertyContainer, PropertyInclusionPolicy<T> propertyInclusionPolicy) {
        this.wrappedIterator = wrappedIterator.iterator();
        this.wrappedPropertyContainer = wrappedPropertyContainer;
        this.propertyInclusionPolicy = propertyInclusionPolicy;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    protected String fetchNextOrNull() {
        while (this.wrappedIterator.hasNext()) {
            String key = this.wrappedIterator.next();
            if (!this.propertyInclusionPolicy.include(key, this.wrappedPropertyContainer)) continue;
            return key;
        }
        return null;
    }
}

