/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.propertycontainer.filtered;

import com.graphaware.common.policy.inclusion.InclusionPolicies;
import com.graphaware.tx.event.improved.propertycontainer.filtered.FilteredRelationship;
import java.util.Iterator;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class FilteredRelationshipIterator
extends PrefetchingIterator<Relationship>
implements Iterator<Relationship>,
Iterable<Relationship> {
    private final Iterator<Relationship> wrappedIterator;
    private final InclusionPolicies policies;

    public FilteredRelationshipIterator(Iterable<Relationship> wrappedIterable, InclusionPolicies policies) {
        this.wrappedIterator = wrappedIterable.iterator();
        this.policies = policies;
    }

    @Override
    public Iterator<Relationship> iterator() {
        return this;
    }

    protected Relationship fetchNextOrNull() {
        while (this.wrappedIterator.hasNext()) {
            Relationship next = this.wrappedIterator.next();
            if (!this.policies.getRelationshipInclusionPolicy().include((Object)next)) continue;
            return new FilteredRelationship(next, this.policies);
        }
        return null;
    }
}

