/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.propertycontainer.snapshot;

import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import java.util.Iterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class LabelSnapshotIterator
extends PrefetchingIterator<Label>
implements Iterator<Label>,
Iterable<Label> {
    private final Node node;
    private final Iterator<Label> wrappedIterator;
    private final TransactionDataContainer transactionDataContainer;
    private final Iterator<Label> removedLabelsIterator;

    public LabelSnapshotIterator(Node node, Iterable<Label> wrappedIterable, TransactionDataContainer transactionDataContainer) {
        this.node = node;
        this.wrappedIterator = wrappedIterable.iterator();
        this.transactionDataContainer = transactionDataContainer;
        this.removedLabelsIterator = transactionDataContainer.getNodeTransactionData().hasBeenChanged(node) ? transactionDataContainer.getNodeTransactionData().removedLabels(node).iterator() : (transactionDataContainer.getNodeTransactionData().hasBeenDeleted(node) ? transactionDataContainer.getNodeTransactionData().labelsOfDeletedNode(node).iterator() : Iterators.emptyIterator());
    }

    @Override
    public Iterator<Label> iterator() {
        return this;
    }

    protected Label fetchNextOrNull() {
        while (this.wrappedIterator.hasNext()) {
            Label next = this.wrappedIterator.next();
            if (this.transactionDataContainer.getNodeTransactionData().hasLabelBeenAssigned(this.node, next)) continue;
            return next;
        }
        if (this.removedLabelsIterator.hasNext()) {
            return this.removedLabelsIterator.next();
        }
        return null;
    }
}

