/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.propertycontainer.snapshot;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.wrapper.RelationshipWrapper;
import com.graphaware.tx.event.improved.data.PropertyContainerTransactionData;
import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import com.graphaware.tx.event.improved.propertycontainer.snapshot.NodeSnapshot;
import com.graphaware.tx.event.improved.propertycontainer.snapshot.PropertyContainerSnapshot;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.logging.Log;

public class RelationshipSnapshot
extends PropertyContainerSnapshot<Relationship>
implements Relationship,
RelationshipWrapper {
    private static final Log LOG = LoggerFactory.getLogger(RelationshipSnapshot.class);

    public RelationshipSnapshot(Relationship wrapped, TransactionDataContainer transactionDataContainer) {
        super(wrapped, transactionDataContainer);
    }

    @Override
    protected PropertyContainerTransactionData<Relationship> transactionData() {
        return this.transactionDataContainer.getRelationshipTransactionData();
    }

    protected Relationship self() {
        return this;
    }

    public void delete() {
        if (this.transactionDataContainer.getRelationshipTransactionData().hasBeenDeleted(this.wrapped)) {
            LOG.warn("Relationship " + this.getId() + " has already been deleted in this transaction.");
        } else {
            super.delete();
        }
    }

    protected Node wrapNode(Node node) {
        return new NodeSnapshot(node, this.transactionDataContainer);
    }
}

