/*
 * Copyright (c) 2013-2020 GraphAware
 *
 * This file is part of the GraphAware Framework.
 *
 * GraphAware Framework is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of
 * the GNU General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

package com.graphaware.tx.event.improved.data;

import org.neo4j.graphdb.event.TransactionData;

/**
 * A component that contains {@link NodeTransactionData} and {@link RelationshipTransactionData}.
 */
public interface TransactionDataContainer extends TransactionDataWrapper {

    /**
     * Get contained node transaction data.
     *
     * @return node transaction data.
     */
    NodeTransactionData getNodeTransactionData();

    /**
     * Get contained relationship transaction data.
     *
     * @return relationship transaction data.
     */
    RelationshipTransactionData getRelationshipTransactionData();
}
