/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.data;

import com.graphaware.common.util.Change;
import com.graphaware.common.util.EntityUtils;
import com.graphaware.tx.event.improved.data.NodeTransactionData;
import com.graphaware.tx.event.improved.data.RelationshipTransactionData;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.event.TransactionData;

public abstract class BaseImprovedTransactionData {
    private final TransactionData wrapped;

    public BaseImprovedTransactionData(TransactionData wrapped) {
        this.wrapped = wrapped;
    }

    protected abstract NodeTransactionData getNodeTransactionData();

    protected abstract RelationshipTransactionData getRelationshipTransactionData();

    public boolean hasBeenCreated(Node node) {
        return this.getNodeTransactionData().hasBeenCreated(node);
    }

    public Collection<Node> getAllCreatedNodes() {
        return this.getNodeTransactionData().getAllCreated();
    }

    public boolean hasBeenDeleted(Node node) {
        return this.getNodeTransactionData().hasBeenDeleted(node);
    }

    public Node getDeleted(Node node) {
        return this.getNodeTransactionData().getDeleted(node);
    }

    public Collection<Node> getAllDeletedNodes() {
        return this.getNodeTransactionData().getAllDeleted();
    }

    public boolean hasBeenChanged(Node node) {
        return this.getNodeTransactionData().hasBeenChanged(node);
    }

    public Change<Node> getChanged(Node node) {
        return this.getNodeTransactionData().getChanged(node);
    }

    public Collection<Change<Node>> getAllChangedNodes() {
        return this.getNodeTransactionData().getAllChanged();
    }

    public boolean hasPropertyBeenCreated(Node node, String key) {
        return this.getNodeTransactionData().hasPropertyBeenCreated(node, key);
    }

    public Map<String, Object> createdProperties(Node node) {
        return this.getNodeTransactionData().createdProperties(node);
    }

    public boolean hasPropertyBeenDeleted(Node node, String key) {
        return this.getNodeTransactionData().hasPropertyBeenDeleted(node, key);
    }

    public Map<String, Object> deletedProperties(Node node) {
        return this.getNodeTransactionData().deletedProperties(node);
    }

    public boolean hasPropertyBeenChanged(Node node, String key) {
        return this.getNodeTransactionData().hasPropertyBeenChanged(node, key);
    }

    public Map<String, Change<Object>> changedProperties(Node node) {
        return this.getNodeTransactionData().changedProperties(node);
    }

    public boolean hasLabelBeenAssigned(Node node, Label label) {
        return this.getNodeTransactionData().hasLabelBeenAssigned(node, label);
    }

    public Set<Label> assignedLabels(Node node) {
        return this.getNodeTransactionData().assignedLabels(node);
    }

    public boolean hasLabelBeenRemoved(Node node, Label label) {
        return this.getNodeTransactionData().hasLabelBeenRemoved(node, label);
    }

    public Set<Label> removedLabels(Node node) {
        return this.getNodeTransactionData().removedLabels(node);
    }

    public boolean hasBeenCreated(Relationship relationship) {
        return this.getRelationshipTransactionData().hasBeenCreated(relationship);
    }

    public Collection<Relationship> getAllCreatedRelationships() {
        return this.getRelationshipTransactionData().getAllCreated();
    }

    public boolean hasBeenDeleted(Relationship relationship) {
        return this.getRelationshipTransactionData().hasBeenDeleted(relationship);
    }

    public Relationship getDeleted(Relationship relationship) {
        return this.getRelationshipTransactionData().getDeleted(relationship);
    }

    public Collection<Relationship> getAllDeletedRelationships() {
        return this.getRelationshipTransactionData().getAllDeleted();
    }

    public Collection<Relationship> getDeletedRelationships(Node node, RelationshipType ... types) {
        return this.getRelationshipTransactionData().getDeleted(node, types);
    }

    public Collection<Relationship> getDeletedRelationships(Node node, Direction direction, RelationshipType ... types) {
        return this.getRelationshipTransactionData().getDeleted(node, direction, types);
    }

    public boolean hasBeenChanged(Relationship relationship) {
        return this.getRelationshipTransactionData().hasBeenChanged(relationship);
    }

    public Change<Relationship> getChanged(Relationship relationship) {
        return this.getRelationshipTransactionData().getChanged(relationship);
    }

    public Collection<Change<Relationship>> getAllChangedRelationships() {
        return this.getRelationshipTransactionData().getAllChanged();
    }

    public boolean hasPropertyBeenCreated(Relationship relationship, String key) {
        return this.getRelationshipTransactionData().hasPropertyBeenCreated(relationship, key);
    }

    public Map<String, Object> createdProperties(Relationship relationship) {
        return this.getRelationshipTransactionData().createdProperties(relationship);
    }

    public boolean hasPropertyBeenDeleted(Relationship relationship, String key) {
        return this.getRelationshipTransactionData().hasPropertyBeenDeleted(relationship, key);
    }

    public Map<String, Object> deletedProperties(Relationship relationship) {
        return this.getRelationshipTransactionData().deletedProperties(relationship);
    }

    public boolean hasPropertyBeenChanged(Relationship relationship, String key) {
        return this.getRelationshipTransactionData().hasPropertyBeenChanged(relationship, key);
    }

    public Map<String, Change<Object>> changedProperties(Relationship relationship) {
        return this.getRelationshipTransactionData().changedProperties(relationship);
    }

    public boolean mutationsOccurred() {
        return !this.getAllCreatedNodes().isEmpty() || !this.getAllCreatedRelationships().isEmpty() || !this.getAllDeletedNodes().isEmpty() || !this.getAllDeletedRelationships().isEmpty() || !this.getAllChangedNodes().isEmpty() || !this.getAllChangedRelationships().isEmpty();
    }

    public Set<String> mutationsToStrings() {
        HashSet<String> result = new HashSet<String>();
        for (Node node : this.getAllCreatedNodes()) {
            result.add("Created node " + EntityUtils.nodeToString((Node)node));
        }
        for (Node node : this.getAllDeletedNodes()) {
            result.add("Deleted node " + EntityUtils.nodeToString((Node)node));
        }
        for (Change change : this.getAllChangedNodes()) {
            result.add("Changed node " + EntityUtils.nodeToString((Node)((Node)change.getPrevious())) + " to " + EntityUtils.nodeToString((Node)((Node)change.getCurrent())));
        }
        for (Relationship relationship : this.getAllCreatedRelationships()) {
            result.add("Created relationship " + EntityUtils.relationshipToString((Relationship)relationship));
        }
        for (Relationship relationship : this.getAllDeletedRelationships()) {
            result.add("Deleted relationship " + EntityUtils.relationshipToString((Relationship)relationship));
        }
        for (Change change : this.getAllChangedRelationships()) {
            result.add("Changed relationship " + EntityUtils.relationshipToString((Relationship)((Relationship)change.getPrevious())) + " to " + EntityUtils.relationshipToString((Relationship)((Relationship)change.getCurrent())));
        }
        return result;
    }

    public TransactionData getWrapped() {
        return this.wrapped;
    }
}

