/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.data.filtered;

import com.graphaware.common.policy.inclusion.EntityInclusionPolicy;
import com.graphaware.common.policy.inclusion.InclusionPolicies;
import com.graphaware.common.policy.inclusion.PropertyInclusionPolicy;
import com.graphaware.common.policy.inclusion.none.IncludeNoProperties;
import com.graphaware.common.policy.inclusion.none.IncludeNone;
import com.graphaware.common.util.Change;
import com.graphaware.tx.event.improved.data.EntityTransactionData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.neo4j.graphdb.Entity;

public abstract class FilteredEntityTransactionData<T extends Entity> {
    protected final InclusionPolicies policies;

    protected FilteredEntityTransactionData(InclusionPolicies policies) {
        this.policies = policies;
    }

    protected abstract EntityTransactionData<T> getWrapped();

    protected abstract EntityInclusionPolicy<T> getEntityInclusionPolicy();

    protected abstract PropertyInclusionPolicy<T> getPropertyInclusionPolicy();

    protected abstract T filtered(T var1);

    public boolean hasBeenCreated(T entity) {
        return this.getWrapped().hasBeenCreated(entity);
    }

    public Collection<T> getAllCreated() {
        if (this.getEntityInclusionPolicy() instanceof IncludeNone) {
            return Collections.emptySet();
        }
        return this.filterEntities(this.getWrapped().getAllCreated());
    }

    public boolean hasBeenDeleted(T entity) {
        return this.getWrapped().hasBeenDeleted(entity);
    }

    public T getDeleted(T entity) {
        return this.filtered(this.getWrapped().getDeleted(entity));
    }

    public Collection<T> getAllDeleted() {
        if (this.getEntityInclusionPolicy() instanceof IncludeNone) {
            return Collections.emptySet();
        }
        return this.filterEntities(this.getWrapped().getAllDeleted());
    }

    public boolean hasBeenChanged(T entity) {
        return this.getWrapped().hasBeenChanged(entity);
    }

    public Change<T> getChanged(T entity) {
        return this.filteredChange(this.getWrapped().getChanged(entity));
    }

    public Collection<Change<T>> getAllChanged() {
        if (this.getEntityInclusionPolicy() instanceof IncludeNone) {
            return Collections.emptySet();
        }
        return this.filterChangedEntities(this.getWrapped().getAllChanged());
    }

    public boolean hasPropertyBeenCreated(T entity, String key) {
        return this.getWrapped().hasPropertyBeenCreated(entity, key);
    }

    public Map<String, Object> createdProperties(T entity) {
        if (this.getPropertyInclusionPolicy() instanceof IncludeNoProperties) {
            return Collections.emptyMap();
        }
        return this.filterProperties(this.getWrapped().createdProperties(entity), entity);
    }

    public boolean hasPropertyBeenDeleted(T entity, String key) {
        return this.getWrapped().hasPropertyBeenDeleted(entity, key);
    }

    public Map<String, Object> deletedProperties(T entity) {
        if (this.getPropertyInclusionPolicy() instanceof IncludeNoProperties) {
            return Collections.emptyMap();
        }
        return this.filterProperties(this.getWrapped().deletedProperties(entity), entity);
    }

    public Map<String, Object> propertiesOfDeletedEntity(T entity) {
        if (this.getPropertyInclusionPolicy() instanceof IncludeNoProperties) {
            return Collections.emptyMap();
        }
        return this.filterProperties(this.getWrapped().propertiesOfDeletedEntity(entity), entity);
    }

    public boolean hasPropertyBeenChanged(T entity, String key) {
        return this.getWrapped().hasPropertyBeenChanged(entity, key);
    }

    public Map<String, Change<Object>> changedProperties(T entity) {
        if (this.getPropertyInclusionPolicy() instanceof IncludeNoProperties) {
            return Collections.emptyMap();
        }
        return this.filterProperties(this.getWrapped().changedProperties(entity), entity);
    }

    protected final Collection<T> filterEntities(Collection<T> toFilter) {
        HashSet<Entity> result = new HashSet<Entity>();
        for (Entity candidate : toFilter) {
            if (!this.getEntityInclusionPolicy().include((Object)candidate)) continue;
            result.add(this.filtered(candidate));
        }
        return result;
    }

    protected final Collection<Change<T>> filterChangedEntities(Collection<Change<T>> toFilter) {
        HashSet<Change<T>> result = new HashSet<Change<T>>();
        for (Change<T> candidate : toFilter) {
            if (!this.include(candidate) || !this.hasChanged(candidate)) continue;
            result.add(this.filteredChange(candidate));
        }
        return result;
    }

    private boolean include(Change<T> candidate) {
        return this.getEntityInclusionPolicy().include(candidate.getPrevious()) || this.getEntityInclusionPolicy().include(candidate.getCurrent());
    }

    protected boolean hasChanged(Change<T> candidate) {
        return !this.createdProperties((Entity)candidate.getPrevious()).isEmpty() || !this.deletedProperties((Entity)candidate.getPrevious()).isEmpty() || !this.changedProperties((Entity)candidate.getPrevious()).isEmpty();
    }

    protected final <V> Map<String, V> filterProperties(Map<String, V> properties, T entity) {
        HashMap<String, V> result = new HashMap<String, V>();
        for (Map.Entry<String, V> entry : properties.entrySet()) {
            if (!this.getPropertyInclusionPolicy().include(entry.getKey(), entity)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected final Change<T> filteredChange(Change<T> change) {
        return new Change((Object)this.filtered((Entity)change.getPrevious()), (Object)this.filtered((Entity)change.getCurrent()));
    }
}

