/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.data.filtered;

import com.graphaware.common.policy.inclusion.EntityInclusionPolicy;
import com.graphaware.common.policy.inclusion.InclusionPolicies;
import com.graphaware.common.policy.inclusion.PropertyInclusionPolicy;
import com.graphaware.common.util.Change;
import com.graphaware.tx.event.improved.data.NodeTransactionData;
import com.graphaware.tx.event.improved.data.filtered.FilteredEntityTransactionData;
import com.graphaware.tx.event.improved.entity.filtered.FilteredNode;
import java.util.Set;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;

public class FilteredNodeTransactionData
extends FilteredEntityTransactionData<Node>
implements NodeTransactionData {
    private final NodeTransactionData wrapped;

    public FilteredNodeTransactionData(NodeTransactionData wrapped, InclusionPolicies policies) {
        super(policies);
        this.wrapped = wrapped;
    }

    protected NodeTransactionData getWrapped() {
        return this.wrapped;
    }

    @Override
    protected Node filtered(Node original) {
        return new FilteredNode(original, this.policies);
    }

    @Override
    protected EntityInclusionPolicy<Node> getEntityInclusionPolicy() {
        return this.policies.getNodeInclusionPolicy();
    }

    @Override
    protected PropertyInclusionPolicy<Node> getPropertyInclusionPolicy() {
        return this.policies.getNodePropertyInclusionPolicy();
    }

    @Override
    public boolean hasLabelBeenAssigned(Node node, Label label) {
        return this.getWrapped().hasLabelBeenAssigned(node, label);
    }

    @Override
    public Set<Label> assignedLabels(Node node) {
        return this.getWrapped().assignedLabels(node);
    }

    @Override
    public boolean hasLabelBeenRemoved(Node node, Label label) {
        return this.getWrapped().hasLabelBeenRemoved(node, label);
    }

    @Override
    public Set<Label> removedLabels(Node node) {
        return this.getWrapped().removedLabels(node);
    }

    @Override
    public Set<Label> labelsOfDeletedNode(Node node) {
        return this.getWrapped().labelsOfDeletedNode(node);
    }

    @Override
    protected boolean hasChanged(Change<Node> candidate) {
        return super.hasChanged(candidate) || !this.assignedLabels((Node)candidate.getPrevious()).isEmpty() || !this.removedLabels((Node)candidate.getPrevious()).isEmpty();
    }
}

