/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.data.lazy;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.util.Change;
import com.graphaware.tx.event.improved.data.EntityTransactionData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.logging.Log;

public abstract class LazyEntityTransactionData<T extends Entity>
implements EntityTransactionData<T> {
    private static final Log LOG = LoggerFactory.getLogger(LazyEntityTransactionData.class);
    private Map<Long, T> created = null;
    private Map<Long, T> deleted = null;
    private Map<Long, Change<T>> changed = null;
    private Map<Long, Map<String, Object>> createdProperties = null;
    private Map<Long, Map<String, Object>> deletedProperties = null;
    private Map<Long, Map<String, Change<Object>>> changedProperties = null;
    private Map<Long, Map<String, Object>> deletedEntityProperties = null;

    protected abstract T oldSnapshot(T var1);

    protected abstract T newSnapshot(T var1);

    @Override
    public boolean hasBeenCreated(T entity) {
        this.initializeCreated();
        return this.created.containsKey(entity.getId());
    }

    @Override
    public Collection<T> getAllCreated() {
        this.initializeCreated();
        return Collections.unmodifiableCollection(this.created.values());
    }

    private void initializeCreated() {
        if (this.created == null) {
            this.created = new HashMap<Long, T>();
            for (Entity created : this.created()) {
                this.created.put(created.getId(), this.newSnapshot(created));
            }
        }
    }

    protected abstract Iterable<T> created();

    @Override
    public boolean hasBeenDeleted(T entity) {
        this.initializeDeleted();
        return this.deleted.containsKey(entity.getId());
    }

    @Override
    public T getDeleted(T entity) {
        this.initializeDeleted();
        if (!this.hasBeenDeleted(entity)) {
            throw new IllegalArgumentException(entity + " has not been deleted!");
        }
        return (T)((Entity)this.deleted.get(entity.getId()));
    }

    @Override
    public Collection<T> getAllDeleted() {
        this.initializeDeleted();
        return Collections.unmodifiableCollection(this.deleted.values());
    }

    private void initializeDeleted() {
        if (this.deleted == null) {
            this.deleted = new HashMap<Long, T>();
            for (Entity deleted : this.deleted()) {
                this.deleted.put(deleted.getId(), this.oldSnapshot(deleted));
            }
        }
    }

    protected abstract Iterable<T> deleted();

    @Override
    public boolean hasBeenChanged(T entity) {
        this.initializeChanged();
        return this.changedContainsKey(entity);
    }

    @Override
    public Change<T> getChanged(T entity) {
        this.initializeChanged();
        if (!this.hasBeenChanged(entity)) {
            throw new IllegalArgumentException(entity + " has not been changed!");
        }
        return this.changed.get(entity.getId());
    }

    @Override
    public Collection<Change<T>> getAllChanged() {
        this.initializeChanged();
        return Collections.unmodifiableCollection(this.changed.values());
    }

    protected void initializeChanged() {
        this.initializeCreated();
        this.initializeDeleted();
        if (this.changed == null) {
            Entity candidate;
            this.changed = new HashMap<Long, Change<T>>();
            for (PropertyEntry<T> propertyEntry : this.assignedProperties()) {
                if (this.hasNotActuallyChanged(propertyEntry) || this.hasBeenCreated(candidate = (Entity)propertyEntry.entity())) continue;
                this.registerChange(candidate);
            }
            for (PropertyEntry<T> propertyEntry : this.removedProperties()) {
                candidate = (Entity)propertyEntry.entity();
                if (this.hasBeenDeleted(candidate)) continue;
                this.registerChange(candidate);
            }
            this.doInitializeChanged();
        }
    }

    protected void doInitializeChanged() {
    }

    protected void registerChange(T candidate) {
        if (!this.changedContainsKey(candidate)) {
            Change<T> change = this.createChangeObject(candidate);
            this.changed.put(candidate.getId(), change);
        }
    }

    protected boolean changedContainsKey(T candidate) {
        return this.changed.containsKey(candidate.getId());
    }

    protected Change<T> createChangeObject(T candidate) {
        return new Change(this.oldSnapshot(candidate), this.newSnapshot(candidate));
    }

    protected abstract Iterable<PropertyEntry<T>> assignedProperties();

    protected abstract Iterable<PropertyEntry<T>> removedProperties();

    @Override
    public boolean hasPropertyBeenCreated(T entity, String key) {
        this.initializeProperties();
        if (!this.hasBeenChanged(entity)) {
            LOG.warn(entity + " has not been changed but the caller thinks it should have created properties.");
            return false;
        }
        if (!this.createdProperties.containsKey(entity.getId())) {
            return false;
        }
        return this.createdProperties.get(entity.getId()).containsKey(key);
    }

    @Override
    public Map<String, Object> createdProperties(T entity) {
        this.initializeProperties();
        if (!this.hasBeenChanged(entity)) {
            LOG.warn(entity + " has not been changed but the caller thinks it should have created properties.");
            return Collections.emptyMap();
        }
        if (!this.createdProperties.containsKey(entity.getId())) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.createdProperties.get(entity.getId()));
    }

    @Override
    public boolean hasPropertyBeenDeleted(T entity, String key) {
        this.initializeProperties();
        if (!this.hasBeenChanged(entity)) {
            LOG.warn(entity + " has not been changed but the caller thinks it should have deleted properties.");
            return false;
        }
        if (!this.deletedProperties.containsKey(entity.getId())) {
            return false;
        }
        return this.deletedProperties.get(entity.getId()).containsKey(key);
    }

    @Override
    public Map<String, Object> deletedProperties(T entity) {
        this.initializeProperties();
        if (!this.hasBeenChanged(entity)) {
            LOG.warn(entity + " has not been changed but the caller thinks it should have deleted properties.");
            return Collections.emptyMap();
        }
        if (!this.deletedProperties.containsKey(entity.getId())) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.deletedProperties.get(entity.getId()));
    }

    @Override
    public Map<String, Object> propertiesOfDeletedEntity(T entity) {
        this.initializeProperties();
        if (!this.hasBeenDeleted(entity)) {
            LOG.error(entity + " has not been deleted but the caller thinks it has! This is a bug.");
            throw new IllegalStateException(entity + " has not been deleted but the caller thinks it has! This is a bug.");
        }
        if (!this.deletedEntityProperties.containsKey(entity.getId())) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.deletedEntityProperties.get(entity.getId()));
    }

    @Override
    public boolean hasPropertyBeenChanged(T entity, String key) {
        this.initializeProperties();
        if (!this.hasBeenChanged(entity)) {
            LOG.warn(entity + " has not been changed but the caller thinks it should have changed properties.");
            return false;
        }
        if (!this.changedProperties.containsKey(entity.getId())) {
            return false;
        }
        return this.changedProperties.get(entity.getId()).containsKey(key);
    }

    @Override
    public Map<String, Change<Object>> changedProperties(T entity) {
        this.initializeProperties();
        if (!this.hasBeenChanged(entity)) {
            LOG.warn(entity + " has not been changed but the caller thinks it should have changed properties.");
            return Collections.emptyMap();
        }
        if (!this.changedProperties.containsKey(entity.getId())) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.changedProperties.get(entity.getId()));
    }

    private void initializeProperties() {
        Entity entity;
        if (this.createdProperties != null) {
            assert (this.changedProperties != null);
            assert (this.deletedProperties != null);
            assert (this.deletedEntityProperties != null);
            return;
        }
        this.initializeChanged();
        this.createdProperties = new HashMap<Long, Map<String, Object>>();
        this.deletedProperties = new HashMap<Long, Map<String, Object>>();
        this.changedProperties = new HashMap<Long, Map<String, Change<Object>>>();
        this.deletedEntityProperties = new HashMap<Long, Map<String, Object>>();
        for (PropertyEntry<T> propertyEntry : this.assignedProperties()) {
            entity = (Entity)propertyEntry.entity();
            if (this.hasBeenCreated(entity) || this.hasNotActuallyChanged(propertyEntry)) continue;
            if (propertyEntry.previouslyCommitedValue() == null) {
                if (!this.createdProperties.containsKey(entity.getId())) {
                    this.createdProperties.put(entity.getId(), new HashMap());
                }
                this.createdProperties.get(entity.getId()).put(propertyEntry.key(), propertyEntry.value());
                continue;
            }
            if (!this.changedProperties.containsKey(entity.getId())) {
                this.changedProperties.put(entity.getId(), new HashMap());
            }
            this.changedProperties.get(entity.getId()).put(propertyEntry.key(), (Change<Object>)new Change(propertyEntry.previouslyCommitedValue(), propertyEntry.value()));
        }
        for (PropertyEntry<T> propertyEntry : this.removedProperties()) {
            entity = (Entity)propertyEntry.entity();
            if (this.deleted.containsKey(entity.getId())) {
                if (!this.deletedEntityProperties.containsKey(entity.getId())) {
                    this.deletedEntityProperties.put(entity.getId(), new HashMap());
                }
                this.deletedEntityProperties.get(entity.getId()).put(propertyEntry.key(), propertyEntry.previouslyCommitedValue());
                continue;
            }
            if (!this.changedContainsKey(entity)) {
                throw new IllegalStateException(entity + " seems to have not been deleted or changed, this is a bug");
            }
            assert (this.changedContainsKey(entity));
            if (!this.deletedProperties.containsKey(entity.getId())) {
                this.deletedProperties.put(entity.getId(), new HashMap());
            }
            this.deletedProperties.get(entity.getId()).put(propertyEntry.key(), propertyEntry.previouslyCommitedValue());
        }
    }

    private boolean hasNotActuallyChanged(PropertyEntry<T> propertyEntry) {
        return propertyEntry.previouslyCommitedValue() != null && propertyEntry.previouslyCommitedValue().equals(propertyEntry.value());
    }
}

