/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.data.lazy;

import com.graphaware.common.util.Change;
import com.graphaware.common.util.DirectionUtils;
import com.graphaware.tx.event.improved.data.RelationshipTransactionData;
import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import com.graphaware.tx.event.improved.data.lazy.LazyEntityTransactionData;
import com.graphaware.tx.event.improved.entity.snapshot.RelationshipSnapshot;
import java.util.Collection;
import java.util.HashSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;

public class LazyRelationshipTransactionData
extends LazyEntityTransactionData<Relationship>
implements RelationshipTransactionData {
    private final TransactionData transactionData;
    private final TransactionDataContainer transactionDataContainer;

    public LazyRelationshipTransactionData(TransactionData transactionData, TransactionDataContainer transactionDataContainer) {
        this.transactionData = transactionData;
        this.transactionDataContainer = transactionDataContainer;
    }

    @Override
    protected Relationship oldSnapshot(Relationship original) {
        return new RelationshipSnapshot(original, this.transactionDataContainer);
    }

    @Override
    protected Relationship newSnapshot(Relationship original) {
        return original;
    }

    @Override
    protected Iterable<Relationship> created() {
        return this.transactionData.createdRelationships();
    }

    @Override
    protected Iterable<Relationship> deleted() {
        return this.transactionData.deletedRelationships();
    }

    @Override
    protected Iterable<PropertyEntry<Relationship>> assignedProperties() {
        return this.transactionData.assignedRelationshipProperties();
    }

    @Override
    protected Iterable<PropertyEntry<Relationship>> removedProperties() {
        return this.transactionData.removedRelationshipProperties();
    }

    @Override
    public Collection<Relationship> getCreated(Node node, RelationshipType ... types) {
        return this.getCreated(node, Direction.BOTH, types);
    }

    @Override
    public Collection<Relationship> getCreated(Node node, Direction direction, RelationshipType ... types) {
        return this.filterRelationships(this.getAllCreated(), node, direction, types);
    }

    @Override
    public Collection<Relationship> getDeleted(Node node, RelationshipType ... types) {
        return this.getDeleted(node, Direction.BOTH, types);
    }

    @Override
    public Collection<Relationship> getDeleted(Node node, Direction direction, RelationshipType ... types) {
        return this.filterRelationships(this.getAllDeleted(), node, direction, types);
    }

    private Collection<Relationship> filterRelationships(Iterable<Relationship> relationships, Node node, Direction direction, RelationshipType[] types) {
        HashSet<String> typeNames = new HashSet<String>();
        for (RelationshipType type : types) {
            typeNames.add(type.name());
        }
        HashSet<Relationship> result = new HashSet<Relationship>();
        for (Relationship r : relationships) {
            if (!typeNames.isEmpty() && !typeNames.contains(r.getType().name()) || (r.getStartNode().getId() != node.getId() || !DirectionUtils.matches((Relationship)r, (Node)r.getStartNode(), (Direction)direction)) && (r.getEndNode().getId() != node.getId() || !DirectionUtils.matches((Relationship)r, (Node)r.getEndNode(), (Direction)direction))) continue;
            result.add(r);
        }
        return result;
    }

    @Override
    protected Change<Relationship> createChangeObject(Relationship candidate) {
        return new Change((Object)this.oldSnapshot(this.bugWorkaround(candidate)), (Object)this.newSnapshot(this.bugWorkaround(candidate)));
    }

    private Relationship bugWorkaround(Relationship relationship) {
        return relationship.getGraphDatabase().getRelationshipById(relationship.getId());
    }
}

