/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.entity.filtered;

import com.graphaware.common.policy.inclusion.PropertyInclusionPolicy;
import java.util.Iterator;
import org.neo4j.graphdb.Entity;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class FilteredPropertyKeyIterator<T extends Entity>
extends PrefetchingIterator<String>
implements Iterable<String> {
    private final Iterator<String> wrappedIterator;
    private final T wrappedEntity;
    private final PropertyInclusionPolicy<T> propertyInclusionPolicy;

    public FilteredPropertyKeyIterator(Iterable<String> wrappedIterator, T wrappedEntity, PropertyInclusionPolicy<T> propertyInclusionPolicy) {
        this.wrappedIterator = wrappedIterator.iterator();
        this.wrappedEntity = wrappedEntity;
        this.propertyInclusionPolicy = propertyInclusionPolicy;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    protected String fetchNextOrNull() {
        while (this.wrappedIterator.hasNext()) {
            String key = this.wrappedIterator.next();
            if (!this.propertyInclusionPolicy.include(key, this.wrappedEntity)) continue;
            return key;
        }
        return null;
    }
}

