/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.entity.snapshot;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.wrapper.BaseEntityWrapper;
import com.graphaware.tx.event.improved.data.EntityTransactionData;
import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import java.util.HashSet;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.logging.Log;

public abstract class EntitySnapshot<T extends Entity>
extends BaseEntityWrapper<T>
implements Entity {
    private static final Log LOG = LoggerFactory.getLogger(EntitySnapshot.class);
    protected final T wrapped;
    protected final TransactionDataContainer transactionDataContainer;

    protected EntitySnapshot(T wrapped, TransactionDataContainer transactionDataContainer) {
        this.wrapped = wrapped;
        this.transactionDataContainer = transactionDataContainer;
    }

    public T getWrapped() {
        return this.wrapped;
    }

    protected abstract EntityTransactionData<T> transactionData();

    public boolean hasProperty(String key) {
        if (this.transactionData().hasBeenDeleted(this.wrapped)) {
            return this.transactionData().propertiesOfDeletedEntity(this.wrapped).containsKey(key);
        }
        if (this.transactionData().hasBeenChanged(this.wrapped)) {
            if (this.transactionData().hasPropertyBeenCreated(this.wrapped, key)) {
                return false;
            }
            if (this.transactionData().hasPropertyBeenDeleted(this.wrapped, key)) {
                return true;
            }
        }
        return super.hasProperty(key);
    }

    public Object getProperty(String key) {
        if (!this.hasProperty(key)) {
            throw new NotFoundException("Snapshot of " + this.wrapped.toString() + " did not have a property with key " + key);
        }
        if (this.transactionData().hasBeenDeleted(this.wrapped)) {
            return this.transactionData().propertiesOfDeletedEntity(this.wrapped).get(key);
        }
        if (this.transactionData().hasBeenChanged(this.wrapped)) {
            if (this.transactionData().hasPropertyBeenChanged(this.wrapped, key)) {
                return this.transactionData().changedProperties(this.wrapped).get(key).getPrevious();
            }
            if (this.transactionData().hasPropertyBeenDeleted(this.wrapped, key)) {
                return this.transactionData().deletedProperties(this.wrapped).get(key);
            }
        }
        return super.getProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.checkCanBeMutated();
        super.setProperty(key, value);
    }

    public Object removeProperty(String key) {
        this.checkCanBeMutated();
        return super.removeProperty(key);
    }

    protected void checkCanBeMutated() {
        if (this.transactionData().hasBeenDeleted(this.wrapped)) {
            LOG.error("Deleted entity " + this.wrapped + " should not be mutated.");
            throw new IllegalStateException("Deleted entity " + this.wrapped + " should not be mutated.");
        }
    }

    public Iterable<String> getPropertyKeys() {
        if (this.transactionData().hasBeenDeleted(this.wrapped)) {
            return this.transactionData().propertiesOfDeletedEntity(this.wrapped).keySet();
        }
        if (!this.transactionData().hasBeenChanged(this.wrapped)) {
            return super.getPropertyKeys();
        }
        HashSet<String> result = new HashSet<String>();
        for (String key : super.getPropertyKeys()) {
            if (this.transactionData().hasPropertyBeenCreated(this.wrapped, key)) continue;
            result.add(key);
        }
        result.addAll(this.transactionData().deletedProperties(this.wrapped).keySet());
        return result;
    }
}

