/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.entity.snapshot;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.util.IterableUtils;
import com.graphaware.common.wrapper.NodeWrapper;
import com.graphaware.tx.event.improved.data.EntityTransactionData;
import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import com.graphaware.tx.event.improved.entity.snapshot.EntitySnapshot;
import com.graphaware.tx.event.improved.entity.snapshot.LabelSnapshotIterator;
import com.graphaware.tx.event.improved.entity.snapshot.RelationshipSnapshot;
import com.graphaware.tx.event.improved.entity.snapshot.RelationshipSnapshotIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.Log;

public class NodeSnapshot
extends EntitySnapshot<Node>
implements Node,
NodeWrapper {
    private static final Log LOG = LoggerFactory.getLogger(NodeSnapshot.class);

    public NodeSnapshot(Node wrapped, TransactionDataContainer transactionDataContainer) {
        super(wrapped, transactionDataContainer);
    }

    @Override
    protected EntityTransactionData<Node> transactionData() {
        return this.transactionDataContainer.getNodeTransactionData();
    }

    protected Node self() {
        return this;
    }

    public void delete() {
        if (this.transactionDataContainer.getNodeTransactionData().hasBeenDeleted(this.wrapped)) {
            LOG.warn("Node " + this.getId() + " has already been deleted in this transaction.");
        } else {
            super.delete();
        }
    }

    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        this.checkCanBeMutated();
        return super.createRelationshipTo(otherNode, type);
    }

    protected Relationship wrapRelationship(Relationship relationship) {
        return new RelationshipSnapshot(relationship, this.transactionDataContainer);
    }

    protected Iterable<Relationship> wrapRelationships(Iterable<Relationship> relationships, Direction direction, RelationshipType ... relationshipTypes) {
        return new RelationshipSnapshotIterator(this, relationships, this.transactionDataContainer, direction, relationshipTypes);
    }

    public boolean hasLabel(Label label) {
        return IterableUtils.contains(this.getLabels(), (Object)label);
    }

    public Iterable<Label> getLabels() {
        if (this.transactionDataContainer.getNodeTransactionData().hasBeenDeleted(this)) {
            return new LabelSnapshotIterator(this, Iterables.empty(), this.transactionDataContainer);
        }
        return new LabelSnapshotIterator(this, super.getLabels(), this.transactionDataContainer);
    }

    public void addLabel(Label label) {
        this.checkCanBeMutated();
        super.addLabel(label);
    }

    public void removeLabel(Label label) {
        this.checkCanBeMutated();
        super.removeLabel(label);
    }

    public int getDegree() {
        int degree = 0;
        if (!this.transactionDataContainer.getNodeTransactionData().hasBeenDeleted(this)) {
            degree = super.getDegree();
        }
        long removed = IterableUtils.count(this.transactionDataContainer.getRelationshipTransactionData().getDeleted((Node)this, new RelationshipType[0]));
        long added = IterableUtils.count(this.transactionDataContainer.getRelationshipTransactionData().getCreated((Node)this, new RelationshipType[0]));
        return degree + (int)removed - (int)added;
    }

    public int getDegree(RelationshipType type) {
        int degree = 0;
        if (!this.transactionDataContainer.getNodeTransactionData().hasBeenDeleted(this)) {
            degree = super.getDegree(type);
        }
        long removed = IterableUtils.count(this.transactionDataContainer.getRelationshipTransactionData().getDeleted((Node)this, type));
        long added = IterableUtils.count(this.transactionDataContainer.getRelationshipTransactionData().getCreated((Node)this, type));
        return degree + (int)removed - (int)added;
    }

    public int getDegree(Direction direction) {
        int degree = 0;
        if (!this.transactionDataContainer.getNodeTransactionData().hasBeenDeleted(this)) {
            degree = super.getDegree(direction);
        }
        long removed = IterableUtils.count(this.transactionDataContainer.getRelationshipTransactionData().getDeleted((Node)this, direction, new RelationshipType[0]));
        long added = IterableUtils.count(this.transactionDataContainer.getRelationshipTransactionData().getCreated((Node)this, direction, new RelationshipType[0]));
        return degree + (int)removed - (int)added;
    }

    public int getDegree(RelationshipType type, Direction direction) {
        int degree = 0;
        if (!this.transactionDataContainer.getNodeTransactionData().hasBeenDeleted(this)) {
            degree = super.getDegree(type, direction);
        }
        long removed = IterableUtils.count(this.transactionDataContainer.getRelationshipTransactionData().getDeleted((Node)this, direction, type));
        long added = IterableUtils.count(this.transactionDataContainer.getRelationshipTransactionData().getCreated((Node)this, direction, type));
        return degree + (int)removed - (int)added;
    }
}

