/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.entity.snapshot;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.wrapper.RelationshipWrapper;
import com.graphaware.tx.event.improved.data.EntityTransactionData;
import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import com.graphaware.tx.event.improved.entity.snapshot.EntitySnapshot;
import com.graphaware.tx.event.improved.entity.snapshot.NodeSnapshot;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.logging.Log;

public class RelationshipSnapshot
extends EntitySnapshot<Relationship>
implements Relationship,
RelationshipWrapper {
    private static final Log LOG = LoggerFactory.getLogger(RelationshipSnapshot.class);

    public RelationshipSnapshot(Relationship wrapped, TransactionDataContainer transactionDataContainer) {
        super(wrapped, transactionDataContainer);
    }

    @Override
    protected EntityTransactionData<Relationship> transactionData() {
        return this.transactionDataContainer.getRelationshipTransactionData();
    }

    protected Relationship self() {
        return this;
    }

    public void delete() {
        if (this.transactionDataContainer.getRelationshipTransactionData().hasBeenDeleted(this.wrapped)) {
            LOG.warn("Relationship " + this.getId() + " has already been deleted in this transaction.");
        } else {
            super.delete();
        }
    }

    protected Node wrapNode(Node node) {
        return new NodeSnapshot(node, this.transactionDataContainer);
    }
}

